/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.GenericCollectionTypeResolver;

public class CollectionToCollection
implements Converter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public CollectionToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public CollectionToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    public Class getSourceClass() {
        return Collection.class;
    }

    public Class getTargetClass() {
        return Collection.class;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class targetCollectionImpl = this.getCollectionImplClass(targetClass);
        Collection targetCollection = (Collection)targetCollectionImpl.getConstructor(null).newInstance(null);
        ConversionExecutor elementConverter = this.getElementConverter(source, targetClass);
        Collection sourceCollection = (Collection)source;
        for (Object value : sourceCollection) {
            if (elementConverter != null) {
                value = elementConverter.execute(value);
            }
            targetCollection.add(value);
        }
        return targetCollection;
    }

    private Class getCollectionImplClass(Class targetClass) {
        if (targetClass.isInterface()) {
            if (List.class.equals((Object)targetClass)) {
                return ArrayList.class;
            }
            if (Set.class.equals((Object)targetClass)) {
                return LinkedHashSet.class;
            }
            if (SortedSet.class.equals((Object)targetClass)) {
                return TreeSet.class;
            }
            throw new IllegalArgumentException("Unsupported collection interface [" + targetClass.getName() + "]");
        }
        return targetClass;
    }

    private ConversionExecutor getElementConverter(Object source, Class targetClass) {
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        Class elementType = GenericCollectionTypeResolver.getCollectionType((Class)targetClass);
        if (elementType != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

