/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThresholdEvaluatorState
implements ThresholdEvaluatorState {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThresholdEvaluatorState.class);
    private static final String UNKNOWN = "Unknown";
    public static final String FORMATED_NAN = "NaN (the threshold definition has been changed)";

    protected Event createBasicEvent(String uei, Date date, double dsValue, CollectionResourceWrapper resource, Map<String, String> additionalParams) {
        String dsLabelValue;
        if (resource == null) {
            resource = new CollectionResourceWrapper(date, 0, null, null, null, null, null);
        }
        if ((dsLabelValue = resource.getFieldValue(resource.getDsLabel())) == null) {
            dsLabelValue = UNKNOWN;
        }
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression(), date);
        bldr.setNodeid((long)resource.getNodeId());
        bldr.setService(resource.getServiceName());
        bldr.setInterface(InetAddressUtils.addr((String)resource.getHostAddress()));
        if (resource.isAnInterfaceResource()) {
            if (UNKNOWN.equals(dsLabelValue)) {
                dsLabelValue = resource.getIfLabel();
            }
            bldr.addParam("ifLabel", resource.getIfLabel());
            bldr.addParam("ifIndex", resource.getIfIndex());
            String ipaddr = resource.getIfInfoValue("ipaddr");
            if (ipaddr != null && !"0.0.0.0".equals(ipaddr)) {
                bldr.addParam("ifIpAddress", ipaddr);
            }
        }
        if (resource.isNodeResource() && UNKNOWN.equals(dsLabelValue)) {
            dsLabelValue = "node";
        }
        bldr.addParam("label", dsLabelValue);
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.addParam("ds", this.getThresholdConfig().getDatasourceExpression());
        String descr = this.getThresholdConfig().getBasethresholddef().getDescription();
        bldr.addParam("description", descr != null && !descr.trim().equals("") ? descr : this.getThresholdConfig().getDatasourceExpression());
        bldr.addParam("value", this.formatValue(dsValue));
        String defaultInstance = resource.isNodeResource() ? "node" : UNKNOWN;
        bldr.addParam("instance", resource.getInstance() == null ? defaultInstance : resource.getInstance());
        bldr.addParam("instanceLabel", resource.getInstanceLabel() == null ? defaultInstance : resource.getInstanceLabel());
        bldr.addParam("resourceId", resource.getResourceId());
        if (additionalParams != null) {
            for (String p : additionalParams.keySet()) {
                bldr.addParam(p, additionalParams.get(p));
            }
        }
        return bldr.getEvent();
    }

    protected String formatValue(double value) {
        if (Double.isNaN(value)) {
            return FORMATED_NAN;
        }
        String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
        DecimalFormat valueFormatter = new DecimalFormat(pattern);
        return valueFormatter.format(value);
    }
}

