/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.springframework.beans.factory.annotation.Autowired;

final class SyslogdIPMgrDaoImpl
implements SyslogdIPMgr {
    @Autowired
    private IpInterfaceDao ipInt;
    private static Map<String, Long> m_knownips = new ConcurrentHashMap<String, Long>();

    SyslogdIPMgrDaoImpl() {
    }

    public static SyslogdIPMgr getInstance() {
        return new SyslogdIPMgrDaoImpl();
    }

    @Override
    public synchronized void dataSourceSync() throws SQLException {
        List list = this.ipInt.findAll();
        m_knownips.clear();
        for (OnmsIpInterface one : list) {
            if (one == null) continue;
            m_knownips.put(InetAddressUtils.str((InetAddress)one.getIpAddress()), (long)one.getId());
        }
    }

    @Override
    public synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return this.longValue(m_knownips.get(addr));
    }

    @Override
    public long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return this.longValue(m_knownips.put(addr, nodeid));
    }

    @Override
    public long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return this.longValue(m_knownips.remove(addr));
    }

    @Override
    public long longValue(Long result) {
        return result == null ? -1L : result;
    }
}

