/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.PersistenceSelectorStrategy;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class PersistRegexSelectorStrategy
implements PersistenceSelectorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PersistRegexSelectorStrategy.class);
    public static final String MATCH_EXPRESSION = "match-expression";
    public static final String MATCH_STRATEGY = "match-strategy";
    public static final String MATCH_BEHAVIOR = "match-behavior";
    private List<Parameter> m_parameterCollection;

    public boolean shouldPersist(CollectionResource resource) {
        LOG.debug("shouldPersist: checking resource {}", (Object)resource);
        if (this.m_parameterCollection == null) {
            LOG.warn("shouldPersist: no parameters defined; the resource will be persisted.");
            return true;
        }
        EvaluatorContextVisitor visitor = new EvaluatorContextVisitor();
        resource.visit((CollectionSetVisitor)visitor);
        SpelExpressionParser parser = new SpelExpressionParser();
        for (Parameter param : this.m_parameterCollection) {
            if (!param.getKey().equals(MATCH_EXPRESSION)) continue;
            Expression exp = parser.parseExpression(param.getValue());
            boolean shouldPersist = false;
            try {
                shouldPersist = (Boolean)exp.getValue((EvaluationContext)visitor.getEvaluationContext(), Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("shouldPersist: can't evaluate expression {} for resource {} because: {}", new Object[]{param.getValue(), resource, e.getMessage()});
            }
            LOG.debug("shouldPersist: checking {} ? {}", (Object)param.getValue(), (Object)shouldPersist);
            if (!shouldPersist) continue;
            return true;
        }
        return false;
    }

    public void setParameters(List<Parameter> parameterCollection) {
        this.m_parameterCollection = parameterCollection;
    }

    protected static final class EvaluatorContextVisitor
    extends AbstractCollectionSetVisitor {
        private StandardEvaluationContext context = new StandardEvaluationContext();

        public void visitAttribute(CollectionAttribute attribute) {
            if (StringAttributeType.supportsType(attribute.getType())) {
                this.context.setVariable(attribute.getName(), (Object)attribute.getStringValue());
            }
        }

        public StandardEvaluationContext getEvaluationContext() {
            return this.context;
        }
    }
}

