/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.criteria;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.Restriction;

public class Criteria
implements Cloneable {
    private static final Pattern SPLIT_ON = Pattern.compile("\\.");
    private Class<?> m_class;
    private List<Order> m_orders = new ArrayList<Order>();
    private List<Alias> m_aliases = new ArrayList<Alias>();
    private Set<Fetch> m_fetchTypes = new LinkedHashSet<Fetch>();
    private Set<Restriction> m_restrictions = new LinkedHashSet<Restriction>();
    private boolean m_distinct = false;
    private Integer m_limit = null;
    private Integer m_offset = null;
    private LockType m_lockType = null;

    public void visit(CriteriaVisitor visitor) {
        visitor.visitClass(this.getCriteriaClass());
        for (Order order : this.getOrders()) {
            visitor.visitOrder(order);
        }
        visitor.visitOrdersFinished();
        for (Alias alias : this.getAliases()) {
            visitor.visitAlias(alias);
        }
        visitor.visitAliasesFinished();
        for (Fetch fetch : this.getFetchTypes()) {
            visitor.visitFetch(fetch);
        }
        visitor.visitFetchesFinished();
        for (Restriction restriction : this.getRestrictions()) {
            visitor.visitRestriction(restriction);
        }
        visitor.visitRestrictionsFinished();
        visitor.visitDistinct(this.isDistinct());
        visitor.visitLimit(this.getLimit());
        visitor.visitOffset(this.getOffset());
    }

    public Criteria(Class<?> clazz) {
        this.m_class = clazz;
    }

    public final Class<?> getCriteriaClass() {
        return this.m_class;
    }

    public final Collection<Order> getOrders() {
        return Collections.unmodifiableList(this.m_orders);
    }

    public final Criteria setOrders(Collection<? extends Order> orderCollection) {
        if (this.m_orders == orderCollection) {
            return this;
        }
        this.m_orders.clear();
        if (orderCollection != null) {
            this.m_orders.addAll(orderCollection);
        }
        return this;
    }

    public final Collection<Fetch> getFetchTypes() {
        return Collections.unmodifiableList(new ArrayList<Fetch>(this.m_fetchTypes));
    }

    public final Criteria setFetchTypes(Collection<? extends Fetch> fetchTypes) {
        if (this.m_fetchTypes == fetchTypes) {
            return this;
        }
        this.m_fetchTypes.clear();
        this.m_fetchTypes.addAll(fetchTypes);
        return this;
    }

    public final Collection<Alias> getAliases() {
        return Collections.unmodifiableList(this.m_aliases);
    }

    public final Criteria setAliases(Collection<? extends Alias> aliases) {
        if (this.m_aliases == aliases) {
            return this;
        }
        this.m_aliases.clear();
        this.m_aliases.addAll(aliases);
        return this;
    }

    public final Collection<Restriction> getRestrictions() {
        return Collections.unmodifiableList(new ArrayList<Restriction>(this.m_restrictions));
    }

    public final Criteria setRestrictions(Collection<? extends Restriction> restrictions) {
        if (this.m_restrictions == restrictions) {
            return this;
        }
        this.m_restrictions.clear();
        this.m_restrictions.addAll(restrictions);
        return this;
    }

    public final Criteria addRestriction(Restriction restriction) {
        this.m_restrictions.add(restriction);
        return this;
    }

    public final boolean isDistinct() {
        return this.m_distinct;
    }

    public final Criteria setDistinct(boolean distinct) {
        this.m_distinct = distinct;
        return this;
    }

    public final Integer getLimit() {
        return this.m_limit;
    }

    public final Criteria setLimit(Integer limit) {
        this.m_limit = limit;
        return this;
    }

    public final LockType getLockType() {
        return this.m_lockType;
    }

    public final Criteria setLockType(LockType lock) {
        this.m_lockType = lock;
        return this;
    }

    public final Integer getOffset() {
        return this.m_offset;
    }

    public final Criteria setOffset(Integer offset) {
        this.m_offset = offset;
        return this;
    }

    public final Class<?> getType(String path) throws IntrospectionException {
        return this.getType(this.getCriteriaClass(), path);
    }

    private final Class<?> getType(Class<?> clazz, String path) throws IntrospectionException {
        String[] split = SPLIT_ON.split(path);
        List<String> pathSections = Arrays.asList(split);
        return this.getType(clazz, pathSections, new ArrayList<Alias>(this.getAliases()));
    }

    private final Class<?> getType(Class<?> clazz, List<String> pathSections, List<Alias> aliases) throws IntrospectionException {
        if (pathSections.isEmpty()) {
            return clazz;
        }
        String pathElement = pathSections.get(0);
        List<String> remaining = pathSections.subList(1, pathSections.size());
        Iterator<Alias> aliasIterator = aliases.iterator();
        while (aliasIterator.hasNext()) {
            Alias alias = aliasIterator.next();
            if (alias.getAlias().equals(alias.getAssociationPath()) || !alias.getAlias().equals(pathElement)) continue;
            aliasIterator.remove();
            String associationPath = alias.getAssociationPath();
            ArrayList<String> paths = new ArrayList<String>();
            paths.addAll(Arrays.asList(SPLIT_ON.split(associationPath)));
            paths.addAll(remaining);
            return this.getType(clazz, paths, aliases);
        }
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            Type[] t;
            if (!pathElement.equals(pd.getName())) continue;
            Class<?> propertyType = pd.getPropertyType();
            if (Collection.class.isAssignableFrom(propertyType) && (t = this.getGenericReturnType(pd)) != null && t.length == 1) {
                return this.getType((Class)t[0], remaining, aliases);
            }
            return this.getType(propertyType, remaining, aliases);
        }
        return null;
    }

    private final Type[] getGenericReturnType(PropertyDescriptor pd) {
        Type returnType;
        Method m = pd.getReadMethod();
        if (m != null && (returnType = m.getGenericReturnType()) != null && returnType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)returnType;
            return pt.getActualTypeArguments();
        }
        return new Type[0];
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> entries = new ArrayList<String>();
        sb.append("Criteria [");
        if (this.m_class != null) {
            entries.add("class=" + this.m_class.toString());
        }
        if (this.m_orders != null && this.m_orders.size() > 0) {
            entries.add("orders=" + this.m_orders.toString());
        }
        if (this.m_aliases != null && this.m_aliases.size() > 0) {
            entries.add("aliases=" + this.m_aliases.toString());
        }
        if (this.m_fetchTypes != null && this.m_fetchTypes.size() > 0) {
            entries.add("fetchTypes=" + this.m_fetchTypes.toString());
        }
        if (this.m_restrictions != null && this.m_restrictions.size() > 0) {
            entries.add("restrictions=" + this.m_restrictions.toString());
        }
        entries.add("distinct=" + String.valueOf(this.m_distinct));
        if (this.m_limit != null) {
            entries.add("limit=" + String.valueOf(this.m_limit));
        }
        if (this.m_offset != null) {
            entries.add("offset=" + String.valueOf(this.m_offset));
        }
        ListIterator it = entries.listIterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public final Criteria clone() {
        Criteria retval = new Criteria(this.getCriteriaClass());
        retval.setAliases(this.getAliases());
        retval.setDistinct(this.isDistinct());
        retval.setFetchTypes(this.getFetchTypes());
        retval.setLimit(this.getLimit());
        retval.setOffset(this.getOffset());
        retval.setOrders(this.getOrders());
        retval.setRestrictions(this.getRestrictions());
        return retval;
    }

    public static interface CriteriaVisitor {
        public void visitClass(Class<?> var1);

        public void visitOrder(Order var1);

        public void visitOrdersFinished();

        public void visitAlias(Alias var1);

        public void visitAliasesFinished();

        public void visitFetch(Fetch var1);

        public void visitFetchesFinished();

        public void visitLockType(LockType var1);

        public void visitRestriction(Restriction var1);

        public void visitRestrictionsFinished();

        public void visitDistinct(boolean var1);

        public void visitLimit(Integer var1);

        public void visitOffset(Integer var1);
    }

    public static enum LockType {
        NONE,
        READ,
        UPGRADE_NOWAIT,
        WRITE,
        OPTIMISTIC,
        OPTIMISTIC_FORCE_INCREMENT,
        PESSIMISTIC_READ,
        PESSIMISTIC_WRITE,
        PESSIMISTIC_FORCE_INCREMENT;

    }
}

