/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.LtRestriction;
import org.opennms.core.criteria.restrictions.NotNullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.remote.OnmsPollModel;
import org.opennms.netmgt.poller.remote.PolledService;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.poller.remote.PollerConfiguration;
import org.opennms.netmgt.poller.remote.RemoteHostThreadLocal;
import org.opennms.netmgt.poller.remote.support.EmptyPollerConfiguration;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class DefaultPollerBackEnd
implements PollerBackEnd,
SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollerBackEnd.class);
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locMonDao;
    private MonitoredServiceDao m_monSvcDao;
    private EventIpcManager m_eventIpcManager;
    private PollerConfig m_pollerConfig;
    private TimeKeeper m_timeKeeper;
    private int m_disconnectedTimeout;
    @Autowired
    private RrdStrategy<?, ?> m_rrdStrategy;
    private long m_minimumConfigurationReloadInterval;
    private final AtomicReference<Date> m_configurationTimestamp = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, SimplePollerConfiguration>> m_configCache = new AtomicReference();

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_locMonDao, (String)"The LocationMonitorDao must be set");
        Assert.notNull((Object)this.m_monSvcDao, (String)"The MonitoredServiceDao must be set");
        Assert.notNull((Object)this.m_pollerConfig, (String)"The PollerConfig must be set");
        Assert.notNull((Object)this.m_timeKeeper, (String)"The timeKeeper must be set");
        Assert.notNull((Object)this.m_eventIpcManager, (String)"The eventIpcManager must be set");
        Assert.state((this.m_disconnectedTimeout > 0 ? 1 : 0) != 0, (String)"the disconnectedTimeout property must be set");
        Assert.notNull(this.m_rrdStrategy, (String)"The rrdStrategy must be set");
        this.m_minimumConfigurationReloadInterval = Long.getLong("opennms.pollerBackend.minimumConfigurationReloadInterval", 300000L);
        this.configurationUpdated();
    }

    public void start() {
    }

    public void destroy() {
    }

    @Override
    public void checkForDisconnectedMonitors() {
        LOG.debug("Checking for disconnected monitors: disconnectedTimeout = {}", (Object)this.m_disconnectedTimeout);
        try {
            Date now = this.m_timeKeeper.getCurrentDate();
            Date earliestAcceptable = new Date(now.getTime() - (long)this.m_disconnectedTimeout);
            Criteria criteria = new Criteria(OnmsLocationMonitor.class);
            criteria.addRestriction((Restriction)new EqRestriction("status", (Object)OnmsLocationMonitor.MonitorStatus.STARTED));
            criteria.addRestriction((Restriction)new NotNullRestriction("lastUpdated"));
            criteria.addRestriction((Restriction)new LtRestriction("lastUpdated", (Object)earliestAcceptable));
            criteria.setLockType(Criteria.LockType.PESSIMISTIC_READ);
            List monitors = this.m_locMonDao.findMatching(criteria);
            LOG.debug("Found {} monitor(s) that are transitioning to disconnected state", (Object)monitors.size());
            for (OnmsLocationMonitor monitor : monitors) {
                LOG.debug("Monitor {} has stopped responding", (Object)monitor.getName());
                monitor.setStatus(OnmsLocationMonitor.MonitorStatus.DISCONNECTED);
                this.m_locMonDao.update((Object)monitor);
                this.sendDisconnectedEvent(monitor);
            }
        }
        catch (Throwable e) {
            LOG.warn("An error occurred checking for disconnected monitors.", e);
        }
    }

    private OnmsLocationMonitor.MonitorStatus checkForGlobalConfigChange(Date currentConfigurationVersion) {
        if (this.configurationUpdateIsNeeded(currentConfigurationVersion)) {
            return OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
        }
        return OnmsLocationMonitor.MonitorStatus.STARTED;
    }

    private boolean configurationUpdateIsNeeded(Date currentConfigurationVersion) {
        if (this.configIntervalExceedsMinimalInterval(currentConfigurationVersion)) {
            return this.m_configurationTimestamp.get().after(currentConfigurationVersion);
        }
        return false;
    }

    private boolean configIntervalExceedsMinimalInterval(Date currentConfigurationVersion) {
        return this.m_minimumConfigurationReloadInterval > 0L && this.m_timeKeeper.getCurrentTime() - currentConfigurationVersion.getTime() > this.m_minimumConfigurationReloadInterval;
    }

    @Override
    public void configurationUpdated() {
        this.m_configurationTimestamp.set(this.m_timeKeeper.getCurrentDate());
        this.m_configCache.set(new ConcurrentHashMap());
    }

    private static EventBuilder createEventBuilder(OnmsLocationMonitor mon, String uei) {
        EventBuilder eventBuilder = new EventBuilder(uei, "PollerBackEnd").addParam("locationMonitorId", mon.getId()).addParam("location", mon.getLocation());
        return eventBuilder;
    }

    private boolean databaseStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus == null || !currentStatus.getPollResult().equals((Object)newStatus.getPollResult());
    }

    private Date getConfigurationTimestamp() {
        return this.m_configurationTimestamp.get();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<LocationDef> getMonitoringLocations() {
        return this.m_monitoringLocationDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public String getMonitorName(String locationMonitorId) {
        OnmsLocationMonitor locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.load((Serializable)((Object)locationMonitorId));
        return locationMonitor.getName();
    }

    private Map<String, Object> getParameterMap(Service serviceConfig) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (Parameter serviceParm : serviceConfig.getParameters()) {
            String value = serviceParm.getValue();
            if (value == null) {
                value = serviceParm.getAnyObject() == null ? "" : serviceParm.getAnyObject().toString();
            }
            paramMap.put(serviceParm.getKey(), value);
        }
        return paramMap;
    }

    @Override
    @Transactional(readOnly=true)
    public PollerConfiguration getPollerConfiguration(String locationMonitorId) {
        try {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
            if (mon == null) {
                return new EmptyPollerConfiguration();
            }
            List<String> pollingPackageNames = this.getPackageName(mon);
            ArrayList<SimplePollerConfiguration> addMe = new ArrayList<SimplePollerConfiguration>();
            for (String pollingPackageName : pollingPackageNames) {
                SimplePollerConfiguration configInCache;
                ConcurrentHashMap<String, SimplePollerConfiguration> cache = this.m_configCache.get();
                SimplePollerConfiguration pollerConfiguration = cache.get(pollingPackageName);
                if (pollerConfiguration == null && (configInCache = cache.putIfAbsent(pollingPackageName, pollerConfiguration = this.createPollerConfiguration(mon, pollingPackageName))) != null) {
                    pollerConfiguration = configInCache;
                }
                addMe.add(pollerConfiguration);
            }
            return new SimplePollerConfiguration(addMe.toArray(new SimplePollerConfiguration[0]));
        }
        catch (Exception e) {
            LOG.warn("An error occurred retrieving the poller configuration for location monitor ID {}", (Object)locationMonitorId, (Object)e);
            return new EmptyPollerConfiguration();
        }
    }

    private SimplePollerConfiguration createPollerConfiguration(OnmsLocationMonitor mon, String pollingPackageName) {
        Package pkg = this.getPollingPackage(pollingPackageName, mon.getLocation());
        ServiceSelector selector = this.m_pollerConfig.getServiceSelectorForPackage(pkg);
        List services = this.m_monSvcDao.findMatchingServices(selector);
        ArrayList<PolledService> configs = new ArrayList<PolledService>(services.size());
        LOG.debug("found {} services", (Object)services.size());
        for (OnmsMonitoredService monSvc : services) {
            Service serviceConfig = this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg);
            long interval = serviceConfig.getInterval();
            Map<String, Object> parameters = this.getParameterMap(serviceConfig);
            configs.add(new PolledService(monSvc, parameters, new OnmsPollModel(interval)));
        }
        Collections.sort(configs);
        return new SimplePollerConfiguration(this.getConfigurationTimestamp(), configs.toArray(new PolledService[configs.size()]));
    }

    private Package getPollingPackageForMonitorAndService(OnmsLocationMonitor mon, OnmsMonitoredService monSvc) {
        List<String> pollingPackageNames = this.getPackageName(mon);
        String definitionName = mon.getLocation();
        for (String pollingPackageName : pollingPackageNames) {
            Package pkg = this.getPollingPackage(pollingPackageName, definitionName);
            if (this.m_pollerConfig.getServiceInPackage(monSvc.getServiceName(), pkg) == null) continue;
            return pkg;
        }
        throw new IllegalStateException("Could not find package from monitor " + mon.getName() + " that contains service " + monSvc.getServiceName());
    }

    private Package getPollingPackage(String pollingPackageName, String definitionName) {
        Package pkg = this.m_pollerConfig.getPackage(pollingPackageName);
        if (pkg == null) {
            throw new IllegalStateException("Package " + pollingPackageName + " does not exist as defined for monitoring location " + definitionName);
        }
        return pkg;
    }

    private List<String> getPackageName(OnmsLocationMonitor mon) {
        LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)mon.getLocation()));
        if (def == null) {
            throw new IllegalStateException("Location definition '" + mon.getLocation() + "' could not be found for location monitor ID " + mon.getId());
        }
        return def.getPollingPackageNames();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        try {
            ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
            List<String> ex = Arrays.asList(System.getProperty("excludeServiceMonitorsFromRemotePoller", "").trim().split("\\s*,\\s*"));
            for (ServiceMonitorLocator locator : this.m_pollerConfig.getServiceMonitorLocators(context)) {
                if (ex.contains(locator.getServiceName())) continue;
                locators.add(locator);
            }
            LOG.debug("getServiceMonitorLocators: Returning {} locators", (Object)locators.size());
            return locators;
        }
        catch (Exception e) {
            LOG.warn("An error occurred getting the service monitor locators for distribution context: {}", (Object)context, (Object)e);
            return Collections.emptyList();
        }
    }

    private boolean logicalStatusChanged(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        return currentStatus != null || !newStatus.getPollResult().isAvailable();
    }

    @Override
    public OnmsLocationMonitor.MonitorStatus pollerCheckingIn(String locationMonitorId, Date currentConfigurationVersion) {
        try {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
            if (mon == null) {
                LOG.debug("Deleted monitor checked in with ID {}", (Object)locationMonitorId);
                return OnmsLocationMonitor.MonitorStatus.DELETED;
            }
            return this.updateMonitorState(mon, currentConfigurationVersion);
        }
        catch (Throwable e) {
            LOG.warn("An error occurred while checking in.", e);
            return OnmsLocationMonitor.MonitorStatus.DISCONNECTED;
        }
    }

    @Override
    public boolean pollerStarting(String locationMonitorId, Map<String, String> pollerDetails) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        if (mon == null) {
            return false;
        }
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
        this.updateConnectionHostDetails(mon, pollerDetails);
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStartedEvent(mon);
        return true;
    }

    protected void updateConnectionHostDetails(OnmsLocationMonitor mon, Map<String, String> pollerDetails) {
        HashMap<String, String> allDetails = new HashMap<String, String>();
        if (pollerDetails != null) {
            allDetails.putAll(pollerDetails);
        }
        String oldConnectionHostAddress = (String)allDetails.get("org.opennms.netmgt.poller.remote.connectionHostAddress");
        String newConnectionHostAddress = null;
        String remoteHost = (String)RemoteHostThreadLocal.INSTANCE.get();
        if (remoteHost != null) {
            remoteHost = remoteHost.trim();
            allDetails.put("org.opennms.netmgt.poller.remote.connectionHostName", remoteHost);
            try {
                InetAddress addr = InetAddressUtils.getInetAddress((String)remoteHost);
                newConnectionHostAddress = InetAddressUtils.str((InetAddress)addr);
                allDetails.put("org.opennms.netmgt.poller.remote.connectionHostAddress", newConnectionHostAddress);
                if (remoteHost.equals(newConnectionHostAddress)) {
                    allDetails.put("org.opennms.netmgt.poller.remote.connectionHostName", addr.getHostName());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mon.setProperties(allDetails);
        if (oldConnectionHostAddress == null) {
            if (newConnectionHostAddress != null) {
                this.sendMonitorRemoteAddressChangedEvent(mon, oldConnectionHostAddress, newConnectionHostAddress);
            }
        } else if (!oldConnectionHostAddress.equals(newConnectionHostAddress)) {
            this.sendMonitorRemoteAddressChangedEvent(mon, oldConnectionHostAddress, newConnectionHostAddress);
        }
    }

    private void sendMonitorRemoteAddressChangedEvent(OnmsLocationMonitor mon, String oldRemoteHostAddress, String newRemoteHostAddress) {
        this.m_eventIpcManager.sendNow(DefaultPollerBackEnd.createEventBuilder(mon, "uei.opennms.org/remote/locationMonitorConnectionAddressChanged").addParam("oldConnectionHostAddress", oldRemoteHostAddress).addParam("newConnectionHostAddress", newRemoteHostAddress).getEvent());
    }

    @Override
    public void pollerStopping(String locationMonitorId) {
        OnmsLocationMonitor mon = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        if (mon == null) {
            LOG.info("pollerStopping was called for location monitor ID {} which does not exist", (Object)locationMonitorId);
            return;
        }
        if (mon.getStatus() != OnmsLocationMonitor.MonitorStatus.PAUSED) {
            mon.setStatus(OnmsLocationMonitor.MonitorStatus.STOPPED);
        }
        mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
        this.m_locMonDao.update((Object)mon);
        this.sendMonitorStoppedEvent(mon);
    }

    private void processStatusChange(OnmsLocationSpecificStatus currentStatus, OnmsLocationSpecificStatus newStatus) {
        if (this.databaseStatusChanged(currentStatus, newStatus)) {
            this.m_locMonDao.saveStatusChange(newStatus);
            PollStatus pollResult = newStatus.getPollResult();
            if (this.logicalStatusChanged(currentStatus, newStatus)) {
                this.sendRegainedOrLostServiceEvent(newStatus, pollResult);
            }
        }
    }

    @Override
    public String registerLocationMonitor(String monitoringLocationId) {
        LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)monitoringLocationId));
        if (def == null) {
            throw new ObjectRetrievalFailureException(LocationDef.class, (Object)monitoringLocationId, "Location monitor definition with the id '" + monitoringLocationId + "' not found", null);
        }
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setId(UUID.randomUUID().toString());
        mon.setLocation(def.getLocationName());
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.REGISTERED);
        this.m_locMonDao.save((Object)mon);
        this.sendMonitorRegisteredEvent(mon);
        return mon.getId();
    }

    @Override
    public void reportResult(String locationMonitorId, int serviceId, PollStatus pollResult) {
        OnmsMonitoredService monSvc;
        OnmsLocationMonitor locationMonitor;
        try {
            locationMonitor = (OnmsLocationMonitor)this.m_locMonDao.get((Serializable)((Object)locationMonitorId));
        }
        catch (Exception e) {
            LOG.info("Unable to report result for location monitor ID {}: Location monitor does not exist.", (Object)locationMonitorId, (Object)e);
            return;
        }
        if (locationMonitor == null) {
            LOG.info("Unable to report result for location monitor ID {}: Location monitor does not exist.", (Object)locationMonitorId);
            return;
        }
        try {
            monSvc = (OnmsMonitoredService)this.m_monSvcDao.get((Serializable)Integer.valueOf(serviceId));
        }
        catch (Exception e) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Monitored service does not exist.", new Object[]{locationMonitorId, serviceId, e});
            return;
        }
        if (monSvc == null) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Monitored service does not exist.", (Object)locationMonitorId, (Object)serviceId);
            return;
        }
        if (pollResult == null) {
            LOG.warn("Unable to report result for location monitor ID {}, monitored service ID {}: Poll result is null!", (Object)locationMonitorId, (Object)serviceId);
            return;
        }
        OnmsLocationSpecificStatus newStatus = new OnmsLocationSpecificStatus(locationMonitor, monSvc, pollResult);
        try {
            if (newStatus.getPollResult().getResponseTime() != null) {
                Package pkg = this.getPollingPackageForMonitorAndService(locationMonitor, monSvc);
                this.saveResponseTimeData(locationMonitorId, monSvc, newStatus.getPollResult().getResponseTime(), pkg);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to save response time data for location monitor ID {}, monitored service ID {}.", new Object[]{locationMonitorId, serviceId, e});
        }
        try {
            OnmsLocationSpecificStatus currentStatus = this.m_locMonDao.getMostRecentStatusChange(locationMonitor, monSvc);
            this.processStatusChange(currentStatus, newStatus);
        }
        catch (Exception e) {
            LOG.error("Unable to save result for location monitor ID {}, monitored service ID {}.", new Object[]{locationMonitorId, serviceId, e});
        }
    }

    @Override
    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        String svcName = monSvc.getServiceName();
        Service svc = this.m_pollerConfig.getServiceInPackage(svcName, pkg);
        String dsName = this.getServiceParameter(svc, "ds-name");
        if (dsName == null) {
            return;
        }
        String rrdRepository = this.getServiceParameter(svc, "rrd-repository");
        if (rrdRepository == null) {
            return;
        }
        String rrdDir = rrdRepository + File.separatorChar + "distributed" + File.separatorChar + locationMonitor + File.separator + InetAddressUtils.str((InetAddress)monSvc.getIpAddress());
        try {
            File rrdFile = new File(rrdDir, dsName);
            if (!rrdFile.exists()) {
                RrdUtils.createRRD(this.m_rrdStrategy, (String)locationMonitor, (String)rrdDir, (String)dsName, (int)this.m_pollerConfig.getStep(pkg), (String)"GAUGE", (int)600, (String)"U", (String)"U", (List)this.m_pollerConfig.getRRAList(pkg));
            }
            RrdUtils.updateRRD(this.m_rrdStrategy, (String)locationMonitor, (String)rrdDir, (String)dsName, (long)System.currentTimeMillis(), (String)String.valueOf(responseTime));
        }
        catch (RrdException e) {
            throw new PermissionDeniedDataAccessException("Unable to store rrdData from " + locationMonitor + " for service " + monSvc, (Throwable)e);
        }
    }

    private String getServiceParameter(Service svc, String key) {
        for (Parameter parm : this.m_pollerConfig.parameters(svc)) {
            if (!key.equals(parm.getKey())) continue;
            if (parm.getValue() != null) {
                return parm.getValue();
            }
            if (parm.getAnyObject() == null) continue;
            return parm.getAnyObject().toString();
        }
        return null;
    }

    private void sendMonitorRegisteredEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorRegistered");
    }

    private void sendDisconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorDisconnected");
    }

    private void sendEvent(OnmsLocationMonitor mon, String uei) {
        this.m_eventIpcManager.sendNow(DefaultPollerBackEnd.createEventBuilder(mon, uei).getEvent());
    }

    private void sendMonitorStartedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStarted");
    }

    private void sendMonitorStoppedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorStopped");
    }

    private void sendReconnectedEvent(OnmsLocationMonitor mon) {
        this.sendEvent(mon, "uei.opennms.org/remote/locationMonitorReconnected");
    }

    private void sendRegainedOrLostServiceEvent(OnmsLocationSpecificStatus newStatus, PollStatus pollResult) {
        String uei = pollResult.isAvailable() ? "uei.opennms.org/remote/nodes/nodeRegainedService" : "uei.opennms.org/remote/nodes/nodeLostService";
        EventBuilder builder = DefaultPollerBackEnd.createEventBuilder(newStatus.getLocationMonitor(), uei).setMonitoredService(newStatus.getMonitoredService());
        if (!pollResult.isAvailable() && pollResult.getReason() != null) {
            builder.addParam("eventReason", pollResult.getReason());
        }
        this.m_eventIpcManager.sendNow(builder.getEvent());
    }

    public void setDisconnectedTimeout(int disconnectedTimeout) {
        this.m_disconnectedTimeout = disconnectedTimeout;
    }

    public void setMinimumConfigurationReloadInterval(long value) {
        this.m_minimumConfigurationReloadInterval = value;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locMonDao) {
        this.m_locMonDao = locMonDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    public void setRrdStrategy(RrdStrategy<?, ?> rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    private OnmsLocationMonitor.MonitorStatus updateMonitorState(OnmsLocationMonitor mon, Date currentConfigurationVersion) {
        try {
            switch (mon.getStatus()) {
                case DISCONNECTED: {
                    this.sendReconnectedEvent(mon);
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case STARTED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = this.checkForGlobalConfigChange(currentConfigurationVersion);
                    return monitorStatus;
                }
                case PAUSED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.PAUSED;
                    return monitorStatus;
                }
                case CONFIG_CHANGED: {
                    mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
                    OnmsLocationMonitor.MonitorStatus monitorStatus = OnmsLocationMonitor.MonitorStatus.CONFIG_CHANGED;
                    return monitorStatus;
                }
            }
            LOG.error("Unexpected monitor state for monitor: {}", (Object)mon);
            throw new IllegalStateException("Unexpected monitor state for monitor: " + mon);
        }
        finally {
            mon.setLastUpdated(this.m_timeKeeper.getCurrentDate());
            this.updateConnectionHostDetails(mon, mon.getProperties());
            this.m_locMonDao.update((Object)mon);
        }
    }

    private static class SimplePollerConfiguration
    implements PollerConfiguration,
    Serializable {
        private static final long serialVersionUID = 2L;
        private Date m_timestamp;
        private PolledService[] m_polledServices;
        private long m_serverTime = 0L;

        SimplePollerConfiguration(Date timestamp, PolledService[] polledSvcs) {
            this.m_timestamp = timestamp;
            this.m_polledServices = Arrays.copyOf(polledSvcs, polledSvcs.length);
            this.m_serverTime = System.currentTimeMillis();
        }

        public SimplePollerConfiguration(SimplePollerConfiguration ... pollerConfiguration) {
            this(SimplePollerConfiguration.getNewestTimestamp(pollerConfiguration), SimplePollerConfiguration.combinePolledServices(pollerConfiguration));
        }

        private static Date getNewestTimestamp(SimplePollerConfiguration ... pollerConfigurations) {
            if (pollerConfigurations == null || pollerConfigurations.length < 1) {
                return new Date(0L);
            }
            Date retval = new Date(0L);
            for (SimplePollerConfiguration config : pollerConfigurations) {
                Date current = config.getConfigurationTimestamp();
                if (!retval.before(current)) continue;
                retval = current;
            }
            return retval;
        }

        private static PolledService[] combinePolledServices(SimplePollerConfiguration ... pollerConfigurations) {
            if (pollerConfigurations == null || pollerConfigurations.length < 1) {
                return new PolledService[0];
            }
            TreeSet<PolledService> retval = new TreeSet<PolledService>();
            for (SimplePollerConfiguration config : pollerConfigurations) {
                PolledService[] services = config.getPolledServices();
                retval.addAll(Arrays.asList(services == null ? new PolledService[]{} : services));
            }
            return retval.toArray(new PolledService[0]);
        }

        @Override
        public Date getConfigurationTimestamp() {
            return this.m_timestamp;
        }

        @Override
        public PolledService[] getPolledServices() {
            return this.m_polledServices;
        }

        @Override
        public long getServerTime() {
            return this.m_serverTime;
        }
    }
}

