/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.jmx.JmxCollector;
import org.opennms.netmgt.jmx.JmxCollectorConfig;
import org.opennms.netmgt.jmx.JmxSampleProcessor;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionManager;
import org.opennms.netmgt.jmx.samples.JmxAttributeSample;
import org.opennms.netmgt.jmx.samples.JmxCompositeSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmxCollector
implements JmxCollector {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void collect(JmxCollectorConfig config, JmxSampleProcessor sampleProcessor) throws JmxServerConnectionException {
        DefaultConnectionManager connectionManager = new DefaultConnectionManager(config.getRetries());
        try (JmxServerConnectionWrapper connectionWrapper = connectionManager.connect(config.getConnectionName(), config.getAgentAddress(), config.getServiceProperties(), null);){
            Objects.requireNonNull(connectionWrapper, "connectionWrapper should never be null");
            Objects.requireNonNull(connectionWrapper.getMBeanServerConnection(), "connectionWrapper.getMBeanServerConnection() should never be null");
            MBeanServerConnection concreteConnection = connectionWrapper.getMBeanServerConnection();
            this.collect(concreteConnection, config.getJmxCollection(), sampleProcessor);
        }
    }

    private void collect(MBeanServerConnection concreteConnection, JmxCollection jmxCollection, JmxSampleProcessor sampleProcessor) {
        if (jmxCollection == null || jmxCollection.getMbeanCount() < 1) {
            this.logger.info("No MBeans to collect.");
            return;
        }
        try {
            for (Mbean eachMbean : jmxCollection.getMbeans()) {
                this.logger.debug("Collecting MBean (objectname={}, wildcard={})", (Object)eachMbean.getObjectname(), (Object)this.isWildcard(eachMbean.getObjectname()));
                Set<ObjectName> objectNames = this.getObjectNames(concreteConnection, eachMbean.getObjectname());
                for (ObjectName eachObjectName : objectNames) {
                    this.logger.debug("Collecting ObjectName {}", (Object)eachObjectName);
                    boolean collect = this.canBeCollected(concreteConnection, eachObjectName, eachMbean.getKeyfield(), eachMbean.getExclude());
                    if (collect) {
                        List<String> attributeNames = this.extractAttributeNames(eachMbean);
                        List<Attribute> attributes = this.getAttributes(concreteConnection, eachObjectName, attributeNames);
                        for (Attribute eachAttribute : attributes) {
                            if (eachAttribute.getValue() instanceof CompositeData) {
                                CompositeData compositeData = (CompositeData)eachAttribute.getValue();
                                for (CompMember eachCompositeMember : this.getCompositeMembers(eachMbean, eachAttribute.getName())) {
                                    JmxCompositeSample sample = new JmxCompositeSample(eachMbean, eachAttribute, compositeData, eachCompositeMember);
                                    this.logger.debug("Collected sample {}", (Object)sample);
                                    sampleProcessor.process(sample);
                                }
                                continue;
                            }
                            JmxAttributeSample sample = new JmxAttributeSample(eachMbean, eachAttribute);
                            this.logger.debug("Collected sample {}", (Object)sample);
                            sampleProcessor.process(sample);
                        }
                        continue;
                    }
                    this.logger.debug("Skip ObjectName {}", (Object)eachObjectName);
                }
            }
        }
        catch (JMException e) {
            this.logger.error("Could not collect data", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Could not communicate with MBeanServer", (Throwable)e);
        }
    }

    private boolean canBeCollected(MBeanServerConnection connection, ObjectName objectName, String keyField, String excludeList) throws IOException {
        if (this.isExcluded(objectName, keyField, excludeList)) {
            this.logger.debug("ObjectName {} with key {} is in excludeList {}.", new Object[]{objectName, keyField, excludeList});
            return false;
        }
        if (!connection.isRegistered(objectName)) {
            this.logger.debug("ObjectName {} is not registered.", (Object)objectName);
            return false;
        }
        return true;
    }

    private List<Attribute> getAttributes(MBeanServerConnection concreteConnection, ObjectName eachObjectName, List<String> attributes) throws InstanceNotFoundException, IOException, ReflectionException {
        AttributeList attributeList = concreteConnection.getAttributes(eachObjectName, attributes.toArray(new String[attributes.size()]));
        ArrayList<Attribute> newList = new ArrayList<Attribute>();
        for (Object eachObject : attributeList) {
            if (!(eachObject instanceof Attribute)) continue;
            newList.add((Attribute)eachObject);
        }
        return Collections.checkedList(newList, Attribute.class);
    }

    private List<CompMember> getCompositeMembers(Mbean bean, String compAttributeName) {
        for (CompAttrib eachAttrib : bean.getCompAttribList()) {
            if (!Objects.equals(compAttributeName, eachAttrib.getName())) continue;
            List list = eachAttrib.getCompMemberList();
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<String> extractAttributeNames(Mbean bean) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (Attrib eachAttrib : bean.getAttribList()) {
            attributes.add(eachAttrib.getName());
        }
        for (CompAttrib eachCompAttrib : bean.getCompAttribList()) {
            attributes.add(eachCompAttrib.getName());
        }
        return Collections.unmodifiableList(attributes);
    }

    private boolean isExcluded(ObjectName objectName, String keyField, String excludeList) {
        if (excludeList == null || excludeList.isEmpty()) {
            return false;
        }
        String keyName = objectName.getKeyProperty(keyField);
        if (keyName == null || keyName.isEmpty()) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(excludeList, ",");
        while (st.hasMoreTokens()) {
            if (!keyName.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard(String objectName) {
        return objectName.contains("*");
    }

    private Set<ObjectName> getObjectNames(MBeanServerConnection mbeanServer, String objectName) throws MalformedObjectNameException, IOException {
        HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
        if (this.isWildcard(objectName)) {
            Set<ObjectName> retrievedObjectNames = mbeanServer.queryNames(new ObjectName(objectName), null);
            objectNames.addAll(retrievedObjectNames);
        } else {
            objectNames.add(new ObjectName(objectName));
        }
        return Collections.unmodifiableSet(objectNames);
    }
}

