/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3g;

import java.sql.SQLException;
import java.util.UUID;
import org.postgresql.jdbc3.AbstractJdbc3Connection;
import org.postgresql.jdbc3.AbstractJdbc3Statement;
import org.postgresql.util.ByteConverter;

public abstract class AbstractJdbc3gStatement
extends AbstractJdbc3Statement {
    public AbstractJdbc3gStatement(AbstractJdbc3Connection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability);
    }

    public AbstractJdbc3gStatement(AbstractJdbc3Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, isCallable, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof UUID && this.connection.haveMinimumServerVersion("8.3")) {
            this.setUuid(parameterIndex, (UUID)x);
        } else {
            super.setObject(parameterIndex, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (targetSqlType == 1111 && x instanceof UUID && this.connection.haveMinimumServerVersion("8.3")) {
            this.setUuid(parameterIndex, (UUID)x);
        } else {
            super.setObject(parameterIndex, x, targetSqlType, scale);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }
}

