/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.utils.PropertiesCache;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.StringPropertyAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;

public abstract class ResourceTypeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceTypeUtils.class);
    public static final String DS_PROPERTIES_FILE = "ds.properties";
    public static final String STRINGS_PROPERTIES_FILE_NAME = "strings.properties";
    public static final String RESPONSE_DIRECTORY = "response";
    public static final String SNMP_DIRECTORY = "snmp";
    public static final String FOREIGN_SOURCE_DIRECTORY = "fs";
    private static final PropertiesCache s_cache = new PropertiesCache();
    private static final String[] s_numericTypes = new String[]{"counter", "gauge", "timeticks", "integer", "octetstring"};

    public static boolean isNumericType(String rawType) {
        String type = rawType.toLowerCase();
        for (int i = 0; i < s_numericTypes.length; ++i) {
            String supportedType = s_numericTypes[i];
            if (!type.startsWith(supportedType)) continue;
            return true;
        }
        return false;
    }

    public static Set<OnmsAttribute> getAttributesAtRelativePath(File rrdDirectory, String relativePath, String rrdFileSuffix) {
        HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>();
        ResourceTypeUtils.loadRrdAttributes(rrdDirectory, relativePath, attributes, rrdFileSuffix);
        ResourceTypeUtils.loadStringAttributes(rrdDirectory, relativePath, attributes);
        return attributes;
    }

    private static void loadStringAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes) {
        Properties properties = ResourceTypeUtils.getStringProperties(rrdDirectory, relativePath);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                attributes.add(new StringPropertyAttribute(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    private static void loadRrdAttributes(File rrdDirectory, String relativePath, Set<OnmsAttribute> attributes, final String rrdFileSuffix) {
        int suffixLength = rrdFileSuffix.length();
        File resourceDir = new File(rrdDirectory, relativePath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(rrdFileSuffix);
            }
        };
        File[] files = resourceDir.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (ResourceTypeUtils.isStoreByGroup() && !ResourceTypeUtils.isResponseTime(relativePath)) {
                String groupName = fileName.substring(0, fileName.length() - suffixLength);
                Properties props = ResourceTypeUtils.getDsProperties(resourceDir);
                for (Object o : props.keySet()) {
                    String dsName = (String)o;
                    if (!props.getProperty(dsName).equals(groupName)) continue;
                    attributes.add(new RrdGraphAttribute(dsName, relativePath, fileName));
                }
                continue;
            }
            String dsName = fileName.substring(0, fileName.length() - suffixLength);
            attributes.add(new RrdGraphAttribute(dsName, relativePath, fileName));
        }
    }

    public static Properties getDsProperties(File directory) {
        File propertiesFile = new File(directory, DS_PROPERTIES_FILE);
        try {
            return s_cache.getProperties(propertiesFile);
        }
        catch (IOException e) {
            LOG.error("ds.properties error", (Throwable)e);
            return new Properties();
        }
    }

    public static File getRrdFileForDs(File directory, String ds, String extension) {
        String rrdBaseName = ds;
        if (ResourceTypeUtils.isStoreByGroup()) {
            try {
                rrdBaseName = s_cache.getProperty(new File(directory, DS_PROPERTIES_FILE), ds);
            }
            catch (IOException e) {
                LOG.error("ds.properties error", (Throwable)e);
                rrdBaseName = ds;
            }
        }
        return new File(directory, rrdBaseName + extension);
    }

    public static boolean isStoreByGroup() {
        return Boolean.getBoolean("org.opennms.rrd.storeByGroup");
    }

    public static boolean isStoreByForeignSource() {
        return Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    }

    public static boolean isResponseTime(String relativePath) {
        return Pattern.matches("^response.+$", relativePath);
    }

    public static Properties getStringProperties(File rrdDirectory, String relativePath) {
        Assert.notNull((Object)rrdDirectory, (String)"rrdDirectory argument must not be null");
        Assert.notNull((Object)relativePath, (String)"relativePath argument must not be null");
        File resourceDir = new File(rrdDirectory, relativePath);
        return ResourceTypeUtils.getStringProperties(resourceDir);
    }

    private static Properties getStringProperties(File resourceDir) {
        Assert.notNull((Object)resourceDir, (String)"resourceDir argumnet must not be null");
        return ResourceTypeUtils.getProperties(new File(resourceDir, STRINGS_PROPERTIES_FILE_NAME));
    }

    public static Properties getProperties(File file) {
        try {
            return s_cache.findProperties(file);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            LOG.warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }

    public static void saveUpdatedProperties(File propertiesFile, Properties props) throws FileNotFoundException, IOException {
        s_cache.saveProperties(propertiesFile, props);
    }

    public static void updateDsProperties(File resourceDir, Map<String, String> dsNamesToRrdNames) {
        try {
            s_cache.updateProperties(new File(resourceDir, DS_PROPERTIES_FILE), dsNamesToRrdNames);
        }
        catch (IOException e) {
            LOG.error("Unable to save DataSource Properties file", (Throwable)e);
        }
    }

    public static void updateStringProperty(File resourceDir, String attrVal, String attrName) throws FileNotFoundException, IOException {
        File propertiesFile = new File(resourceDir, STRINGS_PROPERTIES_FILE_NAME);
        s_cache.setProperty(propertiesFile, attrName, attrVal);
    }

    public static String getStringProperty(File directory, String key) {
        File file = new File(directory, STRINGS_PROPERTIES_FILE_NAME);
        try {
            return s_cache.getProperty(file, key);
        }
        catch (IOException e) {
            String message = "loadProperties: Error opening properties file " + file.getAbsolutePath() + ": " + e;
            LOG.warn(message, (Throwable)e);
            throw new DataAccessResourceFailureException(message, (Throwable)e);
        }
    }

    public static File getRelativeNodeSourceDirectory(String nodeSource) {
        String[] ident = ResourceTypeUtils.getFsAndFidFromNodeSource(nodeSource);
        return new File(FOREIGN_SOURCE_DIRECTORY, File.separator + ident[0] + File.separator + ident[1]);
    }

    public static String[] getFsAndFidFromNodeSource(String nodeSource) {
        String[] ident = nodeSource.split(":", 2);
        if (ident.length != 2) {
            LOG.warn("'%s' is not in the format foreignSource:foreignId.", (Object)nodeSource);
            throw new IllegalArgumentException("Node definition '" + nodeSource + "' is invalid, it should be in the format: 'foreignSource:foreignId'.");
        }
        return ident;
    }

    public static OnmsNode getNodeFromResource(OnmsResource resource) {
        if (resource == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)"Resource must be non-null.");
        }
        OnmsEntity entity = resource.getEntity();
        if (entity == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be non-null: " + resource));
        }
        if (!(entity instanceof OnmsNode)) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be an instance of OnmsNode: " + resource));
        }
        return (OnmsNode)entity;
    }
}

