/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResourcePath
implements Iterable<String>,
Comparable<ResourcePath> {
    private final List<String> m_elements = new ArrayList<String>();

    public ResourcePath(String ... path) {
        for (String el : path) {
            this.m_elements.add(el);
        }
    }

    public ResourcePath(ResourcePath parent, String ... path) {
        this.m_elements.addAll(parent.m_elements);
        for (String el : path) {
            this.m_elements.add(el);
        }
    }

    public static ResourcePath get(String ... path) {
        return new ResourcePath(path);
    }

    public static ResourcePath get(ResourcePath parent, String ... path) {
        return new ResourcePath(parent, path);
    }

    public String getName() {
        int k = this.m_elements.size() - 1;
        return k < 0 ? null : this.m_elements.get(k);
    }

    public String[] elements() {
        return this.m_elements.toArray(new String[this.m_elements.size()]);
    }

    @Override
    public Iterator<String> iterator() {
        return this.m_elements.iterator();
    }

    public String toString() {
        return this.m_elements.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_elements == null ? 0 : this.m_elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePath)) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return !(this.m_elements == null ? other.m_elements != null : !this.m_elements.equals(other.m_elements));
    }

    @Override
    public int compareTo(ResourcePath other) {
        return this.toString().compareTo(other.toString());
    }
}

