/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.jmx.ParameterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JmxUtils.class);
    private static final int MAX_ATTRIBUTE_NAME_LENGTH = 19;

    public static Map<String, String> convertToStringMap(Map<String, Object> map) {
        if (map != null) {
            HashMap<String, String> convertedProperties = new HashMap<String, String>();
            for (Map.Entry<String, Object> eachEntry : map.entrySet()) {
                if (!(eachEntry.getValue() instanceof String)) continue;
                convertedProperties.put(eachEntry.getKey(), (String)eachEntry.getValue());
            }
            return Collections.unmodifiableMap(convertedProperties);
        }
        return null;
    }

    public static String getCollectionDirectory(Map<String, String> map, String friendlyName, String serviceName) {
        Objects.requireNonNull(map, "Map must be initialized!");
        if (friendlyName != null && !friendlyName.isEmpty()) {
            return friendlyName;
        }
        if (serviceName != null && !serviceName.isEmpty()) {
            return serviceName.toLowerCase();
        }
        String port = map.get(ParameterName.PORT.toString());
        return port;
    }

    public static String trimAttributeName(String input) {
        if (input != null && input.length() > 19) {
            LOG.warn("attribute '{}' exceeds {} char maximum for RRD data source names, truncating.", (Object)19, (Object)input);
            input = input.substring(0, 19);
        }
        return input;
    }

    public static String getGroupName(Map<String, String> map, Mbean mbean) {
        boolean useMbeanForRrds = Boolean.valueOf(map.get(ParameterName.USE_MBEAN_NAME_FOR_RRDS.toString()));
        String groupName = useMbeanForRrds ? mbean.getName() : mbean.getObjectname();
        return groupName;
    }

    private JmxUtils() {
    }
}

