/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;

public class IsIsLinkDaoHibernate
extends AbstractDaoHibernate<IsIsLink, Integer>
implements IsIsLinkDao {
    public IsIsLinkDaoHibernate() {
        super(IsIsLink.class);
    }

    public IsIsLink get(OnmsNode node, Integer isisCircIndex, Integer isisISAdjIndex) {
        return (IsIsLink)this.findUnique("from IsIsLink as isisLink where isisLink.node = ? and isisLink.isisCircIndex = ? and isisLink.isisISAdjIndex = ? ", node, isisCircIndex, isisISAdjIndex);
    }

    public IsIsLink get(Integer nodeId, Integer isisCircIndex, Integer isisISAdjIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)isisCircIndex, (String)"isisCircIndex cannot be null");
        Assert.notNull((Object)isisISAdjIndex, (String)"isisISAdjIndex cannot be null");
        return (IsIsLink)this.findUnique("from IsIsLink as isisLink where isisLink.node.id = ? and isisLink.isisCircIndex = ? and isisLink.isisISAdjIndex = ? ", nodeId, isisCircIndex, isisISAdjIndex);
    }

    public List<IsIsLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from IsIsLink isisLink where isisLink.node.id = ?", nodeId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        for (IsIsLink link : this.find("from IsIsLink isisLink where isisLink.node.id = ? and isisLinkLastPollTime < ?", nodeId, now)) {
            this.delete(link);
        }
    }

    public List<Object[]> getLinksForTopology() {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Object[]>>(){

            public List<Object[]> doInHibernate(Session session) throws HibernateException, SQLException {
                List list = session.createSQLQuery("select distinct on (distinct_id) least(l1.id, l2.id) as distinct_id, l1.id as source_id, l1.nodeid as source_nodeid, l1.isiscircifindex as l1_isiscircifindex, l2.id as target_id,  l2.nodeid as target_nodeid, l2.isiscircifindex as l2_isiscircifindex from isislink l1 left join isiselement e1 on l1.nodeid = e1.nodeid left join isiselement e2 on l1.isisisadjneighsysid = e2.isissysid left join isislink l2 on e2.nodeid=l2.nodeid where l1.isisisadjindex = l2.isisisadjindex and l2.isisisadjneighsysid = e1.isissysid order by distinct_id;").list();
                return list;
            }
        });
    }
}

