/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.UserNotificationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsUserNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class DatabasePopulator {
    private static final Logger LOG = LoggerFactory.getLogger(DatabasePopulator.class);
    private DistPollerDao m_distPollerDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private ServiceTypeDao m_serviceTypeDao;
    private AssetRecordDao m_assetRecordDao;
    private CategoryDao m_categoryDao;
    private OutageDao m_outageDao;
    private EventDao m_eventDao;
    private AlarmDao m_alarmDao;
    private NotificationDao m_notificationDao;
    private UserNotificationDao m_userNotificationDao;
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locationMonitorDao;
    private AcknowledgmentDao m_acknowledgmentDao;
    private TransactionOperations m_transOperation;
    private OnmsNode m_node1;
    private OnmsNode m_node2;
    private OnmsNode m_node3;
    private OnmsNode m_node4;
    private OnmsNode m_node5;
    private OnmsNode m_node6;
    private boolean m_populateInSeparateTransaction = true;
    private final List<Extension> extensions = new ArrayList<Extension>();
    private Map<Class<? super OnmsDao<?, ?>>, OnmsDao<?, ?>> daoRegistry = new HashMap();

    public <T extends OnmsDao<?, ?>> T lookupDao(Class<? super OnmsDao<?, ?>> daoClass) {
        for (Class<OnmsDao<? super OnmsDao<?, ?>, ? super OnmsDao<?, ?>>> clazz : this.daoRegistry.keySet()) {
            if (!clazz.isAssignableFrom(daoClass)) continue;
            return (T)this.daoRegistry.get(clazz);
        }
        return null;
    }

    public void registerDao(Class<? super OnmsDao<?, ?>> daoClass, OnmsDao<?, ?> dao) {
        if (dao == null || daoClass == null) {
            return;
        }
        for (Class<OnmsDao<? super OnmsDao<?, ?>, ? super OnmsDao<?, ?>>> clazz : this.daoRegistry.keySet()) {
            if (!clazz.isAssignableFrom(daoClass)) continue;
            return;
        }
        this.daoRegistry.put(daoClass, dao);
    }

    public void addExtension(Extension extension) {
        if (extension == null) {
            return;
        }
        this.extensions.add(extension);
    }

    public boolean populateInSeparateTransaction() {
        return this.m_populateInSeparateTransaction;
    }

    public void setPopulateInSeparateTransaction(boolean pop) {
        this.m_populateInSeparateTransaction = pop;
    }

    public void populateDatabase() {
        if (this.m_populateInSeparateTransaction) {
            this.m_transOperation.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    DatabasePopulator.this.doPopulateDatabase();
                }
            });
        } else {
            this.doPopulateDatabase();
        }
    }

    public void resetDatabase() {
        LOG.debug("==== DatabasePopulator Reset ====");
        for (OnmsOutage outage : this.m_outageDao.findAll()) {
            this.m_outageDao.delete((Object)outage);
        }
        for (OnmsUserNotification not : this.m_userNotificationDao.findAll()) {
            this.m_userNotificationDao.delete((Object)not);
        }
        for (OnmsUserNotification not : this.m_notificationDao.findAll()) {
            this.m_notificationDao.delete((Object)not);
        }
        for (OnmsAlarm alarm : this.m_alarmDao.findAll()) {
            this.m_alarmDao.delete((Object)alarm);
        }
        for (OnmsEvent event : this.m_eventDao.findAll()) {
            this.m_eventDao.delete((Object)event);
        }
        for (OnmsSnmpInterface iface : this.m_snmpInterfaceDao.findAll()) {
            this.m_snmpInterfaceDao.delete((Object)iface);
        }
        for (OnmsSnmpInterface iface : this.m_ipInterfaceDao.findAll()) {
            this.m_ipInterfaceDao.delete((Object)iface);
        }
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        for (OnmsServiceType service : this.m_serviceTypeDao.findAll()) {
            this.m_serviceTypeDao.delete((Object)service);
        }
        for (LocationDef location : this.m_monitoringLocationDao.findAll()) {
            this.m_monitoringLocationDao.delete((Object)location);
        }
        LOG.debug("= DatabasePopulatorExtension Reset Starting =");
        for (Extension eachExtension : this.extensions) {
            DaoSupport daoSupport = eachExtension.getDaoSupport();
            Object dao = daoSupport != null && daoSupport.getDaoClass() != null ? (Object)this.lookupDao(daoSupport.getDaoClass()) : null;
            eachExtension.onShutdown(this, dao);
            if (dao == null) continue;
            dao.flush();
        }
        LOG.debug("= DatabasePopulatorExtension Reset Finished =");
        this.m_outageDao.flush();
        this.m_userNotificationDao.flush();
        this.m_notificationDao.flush();
        this.m_alarmDao.flush();
        this.m_eventDao.flush();
        this.m_snmpInterfaceDao.flush();
        this.m_ipInterfaceDao.flush();
        this.m_nodeDao.flush();
        this.m_serviceTypeDao.flush();
        LOG.debug("==== DatabasePopulator Reset Finished ====");
    }

    private void doPopulateDatabase() {
        LOG.debug("==== DatabasePopulator Starting ====");
        NetworkBuilder builder = new NetworkBuilder();
        OnmsNode node1 = this.buildNode1(builder);
        this.getNodeDao().save((Object)node1);
        this.getNodeDao().flush();
        OnmsNode node2 = this.buildNode2(builder);
        this.getNodeDao().save((Object)node2);
        this.getNodeDao().flush();
        this.setNode2(node2);
        OnmsNode node3 = this.buildNode3(builder);
        this.getNodeDao().save((Object)node3);
        this.getNodeDao().flush();
        this.setNode3(node3);
        OnmsNode node4 = this.buildNode4(builder);
        this.getNodeDao().save((Object)node4);
        this.getNodeDao().flush();
        this.setNode4(node4);
        OnmsNode node5 = this.buildNode5(builder);
        this.getNodeDao().save((Object)node5);
        this.getNodeDao().flush();
        this.setNode5(node5);
        OnmsNode node6 = this.buildNode6(builder);
        this.getNodeDao().save((Object)node6);
        this.getNodeDao().flush();
        this.setNode6(node6);
        OnmsEvent event = this.buildEvent(builder.getDistPoller());
        this.getEventDao().save((Object)event);
        this.getEventDao().flush();
        OnmsNotification notif = this.buildTestNotification(builder, event);
        this.getNotificationDao().save((Object)notif);
        this.getNotificationDao().flush();
        OnmsUserNotification userNotif = this.buildTestUserNotification(notif);
        this.getUserNotificationDao().save((Object)userNotif);
        this.getUserNotificationDao().flush();
        OnmsUserNotification userNotif2 = this.buildTestUser2Notification(notif);
        this.getUserNotificationDao().save((Object)userNotif2);
        this.getUserNotificationDao().flush();
        OnmsMonitoredService svc = this.getMonitoredServiceDao().get(node1.getId(), InetAddressUtils.addr((String)"192.168.1.1"), "SNMP");
        OnmsOutage resolved = new OnmsOutage(new Date(), new Date(), event, event, svc, null, null);
        this.getOutageDao().save((Object)resolved);
        this.getOutageDao().flush();
        OnmsOutage unresolved = new OnmsOutage(new Date(), event, svc);
        this.getOutageDao().save((Object)unresolved);
        this.getOutageDao().flush();
        OnmsAlarm alarm = this.buildAlarm(event);
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
        OnmsAcknowledgment ack = new OnmsAcknowledgment();
        ack.setAckTime(new Date());
        ack.setAckType(AckType.UNSPECIFIED);
        ack.setAckAction(AckAction.UNSPECIFIED);
        ack.setAckUser("admin");
        this.getAcknowledgmentDao().save((Object)ack);
        this.getAcknowledgmentDao().flush();
        LocationDef def = new LocationDef();
        def.setLocationName("RDU");
        def.setMonitoringArea("East Coast");
        def.setPollingPackageNames(Collections.singletonList("example1"));
        def.setGeolocation("Research Triangle Park, NC");
        def.setLatitude(Float.valueOf(35.71575f));
        def.setLongitude(Float.valueOf(-79.16262f));
        def.setPriority(Long.valueOf(1L));
        this.m_monitoringLocationDao.save((Object)def);
        LOG.debug("= DatabasePopulatorExtension Populate Starting =");
        for (Extension eachExtension : this.extensions) {
            DaoSupport daoSupport = eachExtension.getDaoSupport();
            Object dao = daoSupport != null ? (Object)daoSupport.getDao() : null;
            Class daoClass = daoSupport != null ? daoSupport.getDaoClass() : null;
            this.registerDao(daoClass, (OnmsDao<?, ?>)dao);
            dao = this.lookupDao(daoClass);
            eachExtension.onPopulate(this, dao);
            if (dao == null) continue;
            dao.flush();
        }
        LOG.debug("= DatabasePopulatorExtension Populate Finished =");
        LOG.debug("==== DatabasePopulator Finished ====");
    }

    private OnmsCategory getCategory(String categoryName) {
        OnmsCategory cat = this.m_categoryDao.findByName(categoryName, true);
        if (cat == null) {
            cat = new OnmsCategory(categoryName);
            this.m_categoryDao.save((Object)cat);
            this.m_categoryDao.flush();
        }
        return cat;
    }

    private OnmsServiceType getService(String serviceName) {
        OnmsServiceType service = this.m_serviceTypeDao.findByName(serviceName);
        if (service == null) {
            service = new OnmsServiceType(serviceName);
            this.m_serviceTypeDao.save((Object)service);
            this.m_serviceTypeDao.flush();
        }
        return service;
    }

    private OnmsNode buildNode1(NetworkBuilder builder) {
        this.setNode1(builder.addNode("node1").setForeignSource("imported:").setForeignId("1").setType(OnmsNode.NodeType.ACTIVE).getNode());
        builder.addCategory(this.getCategory("DEV_AC"));
        builder.addCategory(this.getCategory("IMP_mid"));
        builder.addCategory(this.getCategory("OPS_Online"));
        builder.addCategory(this.getCategory("Routers"));
        builder.setBuilding("HQ");
        builder.addSnmpInterface(1).setCollectionEnabled(true).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).setIfDescr("ATM0").setIfAlias("Initial ifAlias value").setIfType(Integer.valueOf(37)).addIpInterface("192.168.1.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addSnmpInterface(2).setCollectionEnabled(true).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).setIfName("eth0").setIfType(Integer.valueOf(6)).addIpInterface("192.168.1.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addSnmpInterface(3).setCollectionEnabled(false).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).addIpInterface("192.168.1.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        builder.addSnmpInterface(4).setCollectionEnabled(false).setIfOperStatus(Integer.valueOf(1)).setIfSpeed(10000000L).addIpInterface("fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%5").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    private OnmsNode buildNode2(NetworkBuilder builder) {
        builder.addNode("node2").setForeignSource("imported:").setForeignId("2").setType(OnmsNode.NodeType.ACTIVE);
        builder.addCategory(this.getCategory("IMP_mid"));
        builder.addCategory(this.getCategory("Servers"));
        builder.setBuilding("HQ");
        builder.addInterface("192.168.2.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addInterface("192.168.2.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addInterface("192.168.2.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    private OnmsNode buildNode3(NetworkBuilder builder) {
        builder.addNode("node3").setForeignSource("imported:").setForeignId("3").setType(OnmsNode.NodeType.ACTIVE);
        builder.addCategory(this.getCategory("OPS_Online"));
        builder.addInterface("192.168.3.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addInterface("192.168.3.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addInterface("192.168.3.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    private OnmsNode buildNode4(NetworkBuilder builder) {
        builder.addNode("node4").setForeignSource("imported:").setForeignId("4").setType(OnmsNode.NodeType.ACTIVE);
        builder.addCategory(this.getCategory("DEV_AC"));
        builder.addInterface("192.168.4.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addInterface("192.168.4.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addInterface("192.168.4.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    private OnmsNode buildNode5(NetworkBuilder builder) {
        builder.addNode("alternate-node1").setType(OnmsNode.NodeType.ACTIVE).getAssetRecord().setAssetNumber("5");
        builder.addCategory(this.getCategory("DEV_AC"));
        builder.addCategory(this.getCategory("Switches"));
        builder.addInterface("10.1.1.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addInterface("10.1.1.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addInterface("10.1.1.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    private OnmsNode buildNode6(NetworkBuilder builder) {
        builder.addNode("alternate-node2").setType(OnmsNode.NodeType.ACTIVE).getAssetRecord().setDisplayCategory("category1");
        builder.addCategory(this.getCategory("DEV_AC"));
        builder.addInterface("10.1.2.1").setIsManaged("M").setIsSnmpPrimary("P");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("SNMP"));
        builder.addInterface("10.1.2.2").setIsManaged("M").setIsSnmpPrimary("S");
        builder.addService(this.getService("ICMP"));
        builder.addService(this.getService("HTTP"));
        builder.addInterface("10.1.2.3").setIsManaged("M").setIsSnmpPrimary("N");
        builder.addService(this.getService("ICMP"));
        return builder.getCurrentNode();
    }

    public OnmsEvent buildEvent(OnmsDistPoller distPoller) {
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(distPoller);
        event.setEventUei("uei.opennms.org/test");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        return event;
    }

    private OnmsNotification buildTestNotification(NetworkBuilder builder, OnmsEvent event) {
        OnmsNotification notif = new OnmsNotification();
        notif.setEvent(event);
        notif.setTextMsg("This is a test notification");
        notif.setIpAddress(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        notif.setNode(this.m_node1);
        notif.setServiceType(this.getService("ICMP"));
        return notif;
    }

    private OnmsUserNotification buildTestUserNotification(OnmsNotification notif) {
        OnmsUserNotification userNotif = new OnmsUserNotification();
        userNotif.setUserId("TestUser");
        userNotif.setNotification(notif);
        return userNotif;
    }

    private OnmsUserNotification buildTestUser2Notification(OnmsNotification notif) {
        OnmsUserNotification userNotif2 = new OnmsUserNotification();
        userNotif2.setUserId("TestUser2");
        userNotif2.setNotification(notif);
        return userNotif2;
    }

    private OnmsAlarm buildAlarm(OnmsEvent event) {
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller(this.getDistPollerDao().whoami());
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_node1);
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        alarm.setSeverity(OnmsSeverity.NORMAL);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        return alarm;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.m_assetRecordDao = assetRecordDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public DistPollerDao getDistPollerDao() {
        return this.m_distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.m_distPollerDao = distPollerDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monitoredServiceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public NotificationDao getNotificationDao() {
        return this.m_notificationDao;
    }

    public void setNotificationDao(NotificationDao notificationDao) {
        this.m_notificationDao = notificationDao;
    }

    public OutageDao getOutageDao() {
        return this.m_outageDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    public ServiceTypeDao getServiceTypeDao() {
        return this.m_serviceTypeDao;
    }

    public void setServiceTypeDao(ServiceTypeDao serviceTypeDao) {
        this.m_serviceTypeDao = serviceTypeDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public UserNotificationDao getUserNotificationDao() {
        return this.m_userNotificationDao;
    }

    public void setUserNotificationDao(UserNotificationDao userNotificationDao) {
        this.m_userNotificationDao = userNotificationDao;
    }

    public OnmsNode getNode1() {
        return this.m_node1;
    }

    public OnmsNode getNode2() {
        return this.m_node2;
    }

    public OnmsNode getNode3() {
        return this.m_node3;
    }

    public OnmsNode getNode4() {
        return this.m_node4;
    }

    public OnmsNode getNode5() {
        return this.m_node5;
    }

    public OnmsNode getNode6() {
        return this.m_node6;
    }

    private void setNode1(OnmsNode node1) {
        this.m_node1 = node1;
    }

    private void setNode2(OnmsNode node2) {
        this.m_node2 = node2;
    }

    private void setNode3(OnmsNode node3) {
        this.m_node3 = node3;
    }

    private void setNode4(OnmsNode node4) {
        this.m_node4 = node4;
    }

    private void setNode5(OnmsNode node5) {
        this.m_node5 = node5;
    }

    private void setNode6(OnmsNode node6) {
        this.m_node6 = node6;
    }

    public MonitoringLocationDao getMonitoringLocationDao() {
        return this.m_monitoringLocationDao;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public AcknowledgmentDao getAcknowledgmentDao() {
        return this.m_acknowledgmentDao;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.m_acknowledgmentDao = acknowledgmentDao;
    }

    public TransactionOperations getTransactionTemplate() {
        return this.m_transOperation;
    }

    public void setTransactionTemplate(TransactionOperations transactionOperation) {
        this.m_transOperation = transactionOperation;
    }

    public static class DaoSupport<T extends OnmsDao<?, ?>> {
        private final Class<T> daoClass;
        private final T daoObject;

        public DaoSupport(Class<T> daoClass, T daoObject) {
            this.daoClass = daoClass;
            this.daoObject = daoObject;
        }

        public Class<T> getDaoClass() {
            return this.daoClass;
        }

        public T getDao() {
            return this.daoObject;
        }
    }

    public static interface Extension<T extends OnmsDao<?, ?>> {
        public DaoSupport<T> getDaoSupport();

        public void onPopulate(DatabasePopulator var1, T var2);

        public void onShutdown(DatabasePopulator var1, T var2);
    }
}

