/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.standalone;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.standalone.Metric;
import org.opennms.jicmp.standalone.PingReplyListener;
import org.opennms.jicmp.standalone.PingReplyMetric;

public abstract class AbstractPinger<T extends InetAddress>
implements Runnable {
    private NativeDatagramSocket m_pingSocket;
    private Thread m_thread;
    protected final AtomicReference<Throwable> m_throwable = new AtomicReference<Object>(null);
    protected final Metric m_metric = new Metric();
    private volatile boolean m_stopped = false;
    private final List<PingReplyListener> m_listeners = new ArrayList<PingReplyListener>();

    protected AbstractPinger(NativeDatagramSocket pingSocket) {
        this.m_pingSocket = pingSocket;
    }

    protected NativeDatagramSocket getPingSocket() {
        return this.m_pingSocket;
    }

    public int getCount() {
        return this.m_metric.getCount();
    }

    public boolean isFinished() {
        return this.m_stopped;
    }

    public void start() {
        this.m_thread = new Thread((Runnable)this, "PingThreadTest:PingListener");
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public void stop() throws InterruptedException {
        this.m_stopped = true;
        if (this.m_thread != null) {
            this.m_thread.interrupt();
        }
        this.m_thread = null;
    }

    public void closeSocket() {
        if (this.getPingSocket() != null) {
            this.getPingSocket().close();
        }
    }

    protected List<PingReplyListener> getListeners() {
        return this.m_listeners;
    }

    public abstract PingReplyMetric ping(T var1, int var2, int var3, int var4, long var5) throws InterruptedException;

    public void addPingReplyListener(PingReplyListener listener) {
        this.m_listeners.add(listener);
    }

    PingReplyMetric ping(T addr4) throws InterruptedException {
        Thread t = new Thread(this);
        t.start();
        return this.ping(addr4, 1234, 1, 10, 1000L);
    }
}

