/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DebugParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugEventData
implements EventResponseData {
    private int dsTime;
    private int milliSeconds;
    private String perpetratorDN;
    private String formatString;
    private int verb;
    private int parametercount;
    private List parameters = Collections.EMPTY_LIST;

    public DebugEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.dsTime = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.milliSeconds = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.perpetratorDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.formatString = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.verb = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.parametercount = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        if (this.parametercount > 0) {
            this.parameters = new ArrayList();
            ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byteArrayInputStream, nArray);
            for (int i = 0; i < this.parametercount; ++i) {
                this.parameters.add(new DebugParameter((ASN1Tagged)aSN1Sequence.get(i)));
            }
        }
    }

    public int getMilliSeconds() {
        return this.milliSeconds;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public int getVerb() {
        return this.verb;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DebugEventData");
        stringBuffer.append("(Millseconds=" + this.getMilliSeconds() + ")");
        stringBuffer.append("(DSTime =" + this.getDsTime() + ")");
        stringBuffer.append("(PerpetratorDN=" + this.getPerpetratorDN() + ")");
        stringBuffer.append("(Verb=" + this.getVerb() + ")");
        stringBuffer.append("(Parameters=" + this.getParameters() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getDsTime() {
        return this.dsTime;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

