/*
 * Decompiled with CFR 0.152.
 */
package simple.util.cache;

import simple.util.cache.CacheList;

public class Cache {
    private static final int DEFAULT_LOCKS = 20;
    private static final int DEFAULT_LIMIT = 100;
    private CacheList[] list;

    public Cache() {
        this(20, 100);
    }

    public Cache(int regions, int limit) {
        this.init(regions, limit);
    }

    private void init(int regions, int limit) {
        this.list = new CacheList[regions];
        int i = 0;
        while (i < regions) {
            this.list[i] = new CacheList(limit);
            ++i;
        }
    }

    public void cache(Object key, Object obj) {
        int pos = this.translate(key);
        this.list[pos].insert(key, obj);
    }

    private int translate(Object key) {
        int hash = key.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        return hash % this.list.length;
    }

    public Object lookup(Object key) {
        int pos = this.translate(key);
        return this.list[pos].lookup(key);
    }

    public boolean contains(Object key) {
        int pos = this.translate(key);
        return this.list[pos].contains(key);
    }

    public Object remove(Object key) {
        int pos = this.translate(key);
        return this.list[pos].remove(key);
    }

    public void clear() {
        int i = 0;
        while (i < this.list.length) {
            this.list[i].clear();
            ++i;
        }
    }
}

