/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private Logger LOG = LoggerFactory.getLogger(DBUtils.class);
    private final Set<Statement> m_statements = Collections.synchronizedSet(new HashSet());
    private final Set<ResultSet> m_resultSets = Collections.synchronizedSet(new HashSet());
    private final Set<Connection> m_connections = Collections.synchronizedSet(new HashSet());

    public DBUtils() {
        this(DBUtils.class);
    }

    public DBUtils(Class<?> loggingClass) {
        this.LOG = LoggerFactory.getLogger(loggingClass);
    }

    public DBUtils(Class<?> loggingClass, Object ... targets) {
        this(loggingClass);
        for (Object o : targets) {
            this.watch(o);
        }
    }

    public DBUtils setLoggingClass(Class<?> c) {
        this.LOG = LoggerFactory.getLogger(c);
        return this;
    }

    public DBUtils watch(Object o) {
        if (o instanceof Statement) {
            this.m_statements.add((Statement)o);
        } else if (o instanceof ResultSet) {
            this.m_resultSets.add((ResultSet)o);
        } else if (o instanceof Connection) {
            this.m_connections.add((Connection)o);
        }
        return this;
    }

    public void cleanUp() {
        for (ResultSet rs : this.m_resultSets) {
            if (rs == null) continue;
            try {
                rs.close();
            }
            catch (Throwable e) {
                this.LOG.warn("Unable to close result set", e);
            }
        }
        this.m_resultSets.clear();
        for (Statement s : this.m_statements) {
            if (s == null) continue;
            try {
                s.close();
            }
            catch (Throwable e) {
                this.LOG.warn("Unable to close statement", e);
            }
        }
        this.m_statements.clear();
        for (Connection c : this.m_connections) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                this.LOG.warn("Unable to close connection", e);
            }
        }
        this.m_connections.clear();
    }
}

