/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.apache.http.protocol.HttpContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiHttpRoutePlanner
extends DefaultRoutePlanner {
    private static final String DOT = ".";
    public static final Pattern IP_MASK_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final BundleContext bundleContext;
    private final Map<String, ServiceRegistration> registeredConfigurations;

    public OSGiHttpRoutePlanner(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations) {
        super(null);
        this.bundleContext = bundleContext;
        this.registeredConfigurations = registeredConfigurations;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        ProxyConfiguration proxyConfiguration = null;
        for (ServiceRegistration registration : this.registeredConfigurations.values()) {
            String[] arr$;
            int len$;
            int i$;
            Object proxyConfigurationObject = this.bundleContext.getService(registration.getReference());
            if (proxyConfigurationObject == null || !(proxyConfiguration = (ProxyConfiguration)proxyConfigurationObject).isEnabled() || (i$ = 0) >= (len$ = (arr$ = proxyConfiguration.getProxyExceptions()).length)) continue;
            String exception = arr$[i$];
            if (OSGiHttpRoutePlanner.createMatcher(exception).matches(target.getHostName())) {
                return null;
            }
            return new HttpHost(proxyConfiguration.getHostname(), proxyConfiguration.getPort());
        }
        return null;
    }

    private static HostMatcher createMatcher(String name) {
        NetworkAddress na = NetworkAddress.parse(name);
        if (na != null) {
            return new IPAddressMatcher(na);
        }
        if (name.startsWith(DOT)) {
            return new DomainNameMatcher(name);
        }
        return new HostNameMatcher(name);
    }

    private static class NetworkAddress {
        final int address;
        final int mask;

        static NetworkAddress parse(String adrSpec) {
            Matcher nameMatcher;
            if (null != adrSpec && (nameMatcher = IP_MASK_PATTERN.matcher(adrSpec)).matches()) {
                try {
                    int i1 = NetworkAddress.toInt(nameMatcher.group(1), 255);
                    int i2 = NetworkAddress.toInt(nameMatcher.group(2), 255);
                    int i3 = NetworkAddress.toInt(nameMatcher.group(3), 255);
                    int i4 = NetworkAddress.toInt(nameMatcher.group(4), 255);
                    int ip = i1 << 24 | i2 << 16 | i3 << 8 | i4;
                    int mask = NetworkAddress.toInt(nameMatcher.group(6), 32);
                    mask = mask == 32 ? -1 : -1 - (-1 >>> mask);
                    return new NetworkAddress(ip, mask);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static int toInt(String value, int max) {
            if (value == null || value.length() == 0) {
                return max;
            }
            int number = Integer.parseInt(value);
            if (number > max) {
                number = max;
            }
            return number;
        }

        NetworkAddress(int address, int mask) {
            this.address = address;
            this.mask = mask;
        }
    }

    private static class IPAddressMatcher
    implements HostMatcher {
        private final NetworkAddress address;

        IPAddressMatcher(NetworkAddress address) {
            this.address = address;
        }

        public boolean matches(String host) {
            NetworkAddress hostAddress = NetworkAddress.parse(host);
            return hostAddress != null && this.address.address == (hostAddress.address & this.address.mask);
        }
    }

    private static class DomainNameMatcher
    implements HostMatcher {
        private final String domainName;

        DomainNameMatcher(String domainName) {
            this.domainName = domainName.toLowerCase(Locale.ENGLISH);
        }

        public boolean matches(String host) {
            return host.toLowerCase(Locale.ENGLISH).endsWith(this.domainName);
        }
    }

    private static class HostNameMatcher
    implements HostMatcher {
        private final String hostName;

        HostNameMatcher(String hostName) {
            this.hostName = hostName;
        }

        public boolean matches(String host) {
            return this.hostName.equalsIgnoreCase(host);
        }
    }

    private static interface HostMatcher {
        public boolean matches(String var1);
    }
}

