/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MBeanServer;
import mx4j.log.Log;
import org.apache.commons.io.IOUtils;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.vmmgr.Invoker;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.opennms.netmgt.vmmgr.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    private static final Logger LOG = LoggerFactory.getLogger(Starter.class);
    private static final String LOG4J_CATEGORY = "manager";

    private void setLogPrefix() {
        Logging.putPrefix((String)LOG4J_CATEGORY);
    }

    public void startDaemon() {
        try {
            this.configureLog4j();
            this.setLogPrefix();
            this.setupMx4jLogger();
            this.loadGlobalProperties();
            this.setDefaultProperties();
            this.start();
        }
        catch (Exception e) {
            this.die("Exception during startup: " + e.getMessage(), e);
        }
    }

    private void setupMx4jLogger() {
        Log.redirectTo((mx4j.log.Logger)new Mx4jSlf4JLogger());
    }

    private void configureLog4j() {
    }

    private void setDefaultProperties() {
        this.setupFileResourceProperty("opennms.library.jicmp", System.mapLibraryName("jicmp"), "Initialization of ICMP socket will likely fail.");
        this.setupFileResourceProperty("opennms.library.jrrd", System.mapLibraryName("jrrd"), "Initialization of RRD code will likely fail if the JniRrdStrategy is used.");
        this.setupFileResourceProperty("jcifs.properties", "jcifs.properties", "Initialization of JCIFS will likely fail or may be improperly configured.");
    }

    private void setupFileResourceProperty(String propertyName, String file, String notFoundWarning) {
        if (System.getProperty(propertyName) == null) {
            LOG.debug("System property '{}' not set.  Searching for file '{}' in the class path.", (Object)propertyName, (Object)file);
            URL url = this.getClass().getClassLoader().getResource(file);
            if (url != null) {
                LOG.info("Found file '{}' at '{}'.  Setting '{}' to this path.", new Object[]{file, url.getPath(), propertyName});
                System.setProperty(propertyName, url.getPath());
            } else {
                LOG.warn("Did not find file '{}' in the class path. {} Set the property '{}' to the location of the file.", new Object[]{file, notFoundWarning, propertyName});
            }
        } else {
            LOG.debug("System property '{}' already set to '{}'.", (Object)propertyName, (Object)System.getProperty(propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProperties() {
        TreeMap<Object, Object> sortedProps = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry<Object, Object> entry : sortedProps.entrySet()) {
            LOG.debug("System property '{}' already set to value '{}'.", entry.getKey(), entry.getValue());
        }
        File propertiesFile = this.getPropertiesFile();
        if (!propertiesFile.exists()) {
            return;
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFile);
            props.load(in);
        }
        catch (IOException e) {
            try {
                this.die("Error trying to read properties file '" + propertiesFile + "': " + e, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String systemValue = System.getProperty(entry.getKey().toString());
            if (systemValue != null) {
                LOG.debug("Property '{}' from {} already exists as a system property (with value '{}').  Not overridding existing system property.", new Object[]{entry.getKey(), propertiesFile, systemValue});
                continue;
            }
            LOG.debug("Setting system property '{}' to '{}' from {}.", new Object[]{entry.getKey(), entry.getValue(), propertiesFile});
            System.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        if (props.containsKey("networkaddress.cache.ttl")) {
            Security.setProperty("networkaddress.cache.ttl", props.getProperty("networkaddress.cache.ttl"));
        } else {
            Security.setProperty("networkaddress.cache.ttl", "120");
        }
    }

    private void die(String message, Throwable t) {
        LOG.error(message, t);
        System.exit(1);
    }

    public void die(String message) {
        this.die(message, null);
    }

    private File getPropertiesFile() {
        String homeDir = System.getProperty("opennms.home");
        File etcDir = new File(homeDir, "etc");
        return new File(etcDir, "opennms.properties");
    }

    private void start() {
        LOG.debug("Beginning startup");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.START);
        List<InvokerService> services = InvokerService.createServiceList(Invoker.getDefaultServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.instantiateClasses();
        List<InvokerResult> resultInfo = invoker.invokeMethods();
        for (InvokerResult result : resultInfo) {
            if (result == null || result.getThrowable() == null) continue;
            Service service = result.getService();
            String name = service.getName();
            String className = service.getClassName();
            String message = "An error occurred while attempting to start the \"" + name + "\" service (class " + className + ").  " + "Shutting down and exiting.";
            LOG.error(message, result.getThrowable());
            System.err.println(message);
            result.getThrowable().printStackTrace();
            Manager manager = new Manager();
            manager.stop();
            manager.doSystemExit();
            return;
        }
        LOG.debug("Startup complete");
    }

    public static class Mx4jSlf4JLogger
    extends mx4j.log.Logger {
        Logger m_slf4jLogger;

        protected void log(int priority, Object msg, Throwable t) {
            switch (priority) {
                case 10: {
                    this.m_slf4jLogger.debug(msg == null ? "" : msg.toString(), t);
                }
                case 40: {
                    this.m_slf4jLogger.error(msg == null ? "" : msg.toString(), t);
                }
                case 50: {
                    this.m_slf4jLogger.error(msg == null ? "" : msg.toString(), t);
                }
                case 20: {
                    this.m_slf4jLogger.info(msg == null ? "" : msg.toString(), t);
                }
                case 0: {
                    this.m_slf4jLogger.trace(msg == null ? "" : msg.toString(), t);
                }
                case 30: {
                    this.m_slf4jLogger.warn(msg == null ? "" : msg.toString(), t);
                }
            }
        }

        protected void setCategory(String category) {
            super.setCategory(category);
            this.m_slf4jLogger = LoggerFactory.getLogger((String)category);
        }
    }
}

