/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoker {
    private static final Logger LOG = LoggerFactory.getLogger(Invoker.class);
    private MBeanServer m_server;
    private InvokeAtType m_atType;
    private boolean m_reverse = false;
    private boolean m_failFast = true;
    private List<InvokerService> m_services;

    public static ServiceConfigFactory getDefaultServiceConfigFactory() {
        try {
            ServiceConfigFactory.init();
            return ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateClasses() {
        for (InvokerService invokerService : this.getServices()) {
            Service service = invokerService.getService();
            try {
                Object bean;
                LOG.debug("loading class {}", (Object)service.getClassName());
                Class<?> clazz = Class.forName(service.getClassName());
                LOG.debug("create new instance of {}", (Object)service.getClassName());
                Map mdc = Logging.getCopyOfContextMap();
                try {
                    bean = clazz.newInstance();
                }
                finally {
                    Logging.setContextMap((Map)mdc);
                }
                LOG.debug("registering mbean instance {}", (Object)service.getName());
                ObjectName name = new ObjectName(service.getName());
                invokerService.setMbean(this.getServer().registerMBean(bean, name));
                Attribute[] attribs = service.getAttribute();
                if (attribs == null) continue;
                for (Attribute attrib : attribs) {
                    LOG.debug("setting attribute {}", (Object)attrib.getName());
                    this.getServer().setAttribute(name, this.getAttribute(attrib));
                }
            }
            catch (Throwable t) {
                LOG.error("An error occurred loading the mbean {} of type {}", new Object[]{service.getName(), service.getClassName(), t});
                invokerService.setBadThrowable(t);
            }
        }
    }

    public void getObjectInstances() {
        for (InvokerService invokerService : this.getServices()) {
            Service service = invokerService.getService();
            try {
                LOG.debug("finding mbean instance {}", (Object)service.getName());
                ObjectName name = new ObjectName(service.getName());
                invokerService.setMbean(this.getServer().getObjectInstance(name));
            }
            catch (Throwable t) {
                LOG.error("An error occurred loading the mbean {} of type {} it will be skipped", new Object[]{service.getName(), service.getClassName(), t});
                invokerService.setBadThrowable(t);
            }
        }
    }

    public List<InvokerResult> invokeMethods() {
        List<InvokerService> invokerServicesOrdered;
        if (this.isReverse()) {
            invokerServicesOrdered = new ArrayList<InvokerService>(this.getServices());
            Collections.reverse(invokerServicesOrdered);
        } else {
            invokerServicesOrdered = this.getServices();
        }
        ArrayList<InvokerResult> resultInfo = new ArrayList<InvokerResult>(invokerServicesOrdered.size());
        int end = this.getLastPass();
        for (int pass = 0; pass <= end; ++pass) {
            LOG.debug("starting pass {}", (Object)pass);
            for (InvokerService invokerService : invokerServicesOrdered) {
                Service service = invokerService.getService();
                String name = invokerService.getService().getName();
                ObjectInstance mbean = invokerService.getMbean();
                if (invokerService.isBadService()) {
                    resultInfo.add(new InvokerResult(service, mbean, null, invokerService.getBadThrowable()));
                    if (this.isFailFast()) {
                        return resultInfo;
                    }
                }
                for (Invoke invoke : invokerService.getService().getInvoke()) {
                    if (invoke.getPass() != pass || !this.getAtType().equals(invoke.getAt())) continue;
                    LOG.debug("pass {} on service {} will invoke method \"{}\"", new Object[]{pass, name, invoke.getMethod()});
                    try {
                        Object result = this.invoke(invoke, mbean);
                        resultInfo.add(new InvokerResult(service, mbean, result, null));
                    }
                    catch (Throwable t) {
                        resultInfo.add(new InvokerResult(service, mbean, null, t));
                        if (!this.isFailFast()) continue;
                        return resultInfo;
                    }
                }
            }
            LOG.debug("completed pass {}", (Object)pass);
        }
        return resultInfo;
    }

    private int getLastPass() {
        List<InvokerService> invokerServices = this.getServices();
        int end = 0;
        for (InvokerService invokerService : invokerServices) {
            Invoke[] invokes = invokerService.getService().getInvoke();
            if (invokes == null) continue;
            for (Invoke invoke : invokes) {
                if (invoke.getPass() <= end) continue;
                end = invoke.getPass();
            }
        }
        return end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Invoke invoke, ObjectInstance mbean) throws Throwable {
        Object object;
        Argument[] args = invoke.getArgument();
        Object[] parms = new Object[]{};
        String[] sig = new String[]{};
        if (args != null && args.length > 0) {
            parms = new Object[args.length];
            sig = new String[args.length];
            for (int k = 0; k < parms.length; ++k) {
                try {
                    parms[k] = this.getArgument(args[k]);
                }
                catch (Throwable t) {
                    LOG.error("An error occurred building argument {} for operation {} on MBean {}", new Object[]{k, invoke.getMethod(), mbean.getObjectName(), t});
                    throw t;
                }
                sig[k] = parms[k].getClass().getName();
            }
        }
        LOG.debug("Invoking {} on object {}", (Object)invoke.getMethod(), (Object)mbean.getObjectName());
        try {
            Map mdc = Logging.getCopyOfContextMap();
            try {
                object = this.getServer().invoke(mbean.getObjectName(), invoke.getMethod(), parms, sig);
            }
            finally {
                Logging.setContextMap((Map)mdc);
            }
        }
        catch (Throwable t) {
            LOG.error("An error occurred invoking operation {} on MBean {}", new Object[]{invoke.getMethod(), mbean.getObjectName(), t});
            throw t;
        }
        LOG.debug("Invocation {} successful for MBean {}", (Object)invoke.getMethod(), (Object)mbean.getObjectName());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.management.Attribute getAttribute(Attribute attrib) throws Exception {
        Object value;
        Class<?> attribClass = Class.forName(attrib.getValue().getType());
        Constructor<?> construct = attribClass.getConstructor(String.class);
        Map mdc = Logging.getCopyOfContextMap();
        try {
            value = construct.newInstance(attrib.getValue().getContent());
        }
        finally {
            Logging.setContextMap((Map)mdc);
        }
        return new javax.management.Attribute(attrib.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getArgument(Argument arg) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> argClass = Class.forName(arg.getType());
        Constructor<?> construct = argClass.getConstructor(String.class);
        Map mdc = Logging.getCopyOfContextMap();
        try {
            Object obj = construct.newInstance(arg.getContent());
            return obj;
        }
        finally {
            Logging.setContextMap((Map)mdc);
        }
    }

    public InvokeAtType getAtType() {
        return this.m_atType;
    }

    public void setAtType(InvokeAtType atType) {
        this.m_atType = atType;
    }

    public boolean isFailFast() {
        return this.m_failFast;
    }

    public void setFailFast(boolean failFast) {
        this.m_failFast = failFast;
    }

    public boolean isReverse() {
        return this.m_reverse;
    }

    public void setReverse(boolean reverse) {
        this.m_reverse = reverse;
    }

    public MBeanServer getServer() {
        return this.m_server;
    }

    public void setServer(MBeanServer server) {
        this.m_server = server;
    }

    public List<InvokerService> getServices() {
        return this.m_services;
    }

    public void setServices(List<InvokerService> services) {
        this.m_services = services;
    }
}

