/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TrapIdentity;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrapInformation
implements TrapNotification {
    private static final transient Logger LOG = LoggerFactory.getLogger(TrapInformation.class);
    private InetAddress m_agent;
    private String m_community;
    private TrapProcessor m_trapProcessor;

    protected TrapInformation(InetAddress agent, String community, TrapProcessor trapProcessor) {
        this.m_agent = agent;
        this.m_community = community;
        this.m_trapProcessor = trapProcessor;
    }

    protected abstract InetAddress getTrapAddress();

    protected InetAddress getAgent() {
        return this.m_agent;
    }

    protected String getCommunity() {
        return this.m_community;
    }

    protected void validate() {
    }

    protected InetAddress getAgentAddress() {
        return this.getAgent();
    }

    @Override
    public TrapProcessor getTrapProcessor() {
        this.processTrap();
        return this.m_trapProcessor;
    }

    protected abstract String getVersion();

    protected abstract int getPduLength();

    protected abstract long getTimeStamp();

    protected abstract TrapIdentity getTrapIdentity();

    protected void processTrap() {
        this.validate();
        this.m_trapProcessor.setVersion(this.getVersion());
        this.m_trapProcessor.setCommunity(this.getCommunity());
        this.m_trapProcessor.setAgentAddress(this.getAgentAddress());
        this.m_trapProcessor.setTrapAddress(this.getTrapAddress());
        LOG.debug("{} trap - trapInterface: ()", (Object)this.getVersion(), (Object)this.getTrapAddress());
        this.m_trapProcessor.setTimeStamp(this.getTimeStamp());
        this.m_trapProcessor.setTrapIdentity(this.getTrapIdentity());
        for (int i = 0; i < this.getPduLength(); ++i) {
            this.processVarBindAt(i);
        }
    }

    protected abstract void processVarBindAt(int var1);

    protected void processVarBind(SnmpObjId name, SnmpValue value) {
        this.m_trapProcessor.processVarBind(name, value);
    }
}

