/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.StringTokenizer;
import org.opennms.netmgt.snmp.SnmpInstId;

public class SnmpObjId
implements Comparable<SnmpObjId> {
    private int[] m_ids;

    protected SnmpObjId(int[] ids, boolean clone) {
        this.m_ids = clone ? SnmpObjId.cloneIds(ids) : ids;
    }

    protected SnmpObjId(int[] ids) {
        this(ids, true);
    }

    protected SnmpObjId(String oid) {
        this(SnmpObjId.convertStringToInts(oid), false);
    }

    protected SnmpObjId(SnmpObjId oid) {
        this(oid.m_ids);
    }

    private SnmpObjId(String objId, String instance) {
        this(SnmpObjId.appendArrays(SnmpObjId.convertStringToInts(objId), SnmpObjId.convertStringToInts(instance)), false);
    }

    private SnmpObjId(SnmpObjId objId, String instance) {
        this(SnmpObjId.appendArrays(objId.m_ids, SnmpObjId.convertStringToInts(instance)), false);
    }

    private SnmpObjId(SnmpObjId objId, SnmpObjId instance) {
        this(SnmpObjId.appendArrays(objId.m_ids, instance.m_ids), false);
    }

    public int[] getIds() {
        return SnmpObjId.cloneIds(this.m_ids);
    }

    private static int[] cloneIds(int[] ids) {
        return SnmpObjId.cloneIds(ids, ids.length);
    }

    private static int[] cloneIds(int[] ids, int lengthToClone) {
        int len = Math.min(lengthToClone, ids.length);
        int[] newIds = new int[len];
        System.arraycopy(ids, 0, newIds, 0, len);
        return newIds;
    }

    private static int[] convertStringToInts(String oid) {
        if ((oid = oid.trim()).startsWith(".")) {
            oid = oid.substring(1);
        }
        StringTokenizer tokenizer = new StringTokenizer(oid, ".");
        int[] ids = new int[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                String tok = tokenizer.nextToken();
                ids[index] = Integer.parseInt(tok);
                if (ids[index] < 0) {
                    throw new IllegalArgumentException("String " + oid + " could not be converted to a SnmpObjId. It has a negative for subId " + index);
                }
                ++index;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("String " + oid + " could not be converted to a SnmpObjId at subId " + index);
            }
        }
        return ids;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpObjId) {
            return this.compareTo((SnmpObjId)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.length() * 2 + 10);
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0 || this.addPrefixDotInToString()) {
                buf.append('.');
            }
            buf.append(this.m_ids[i]);
        }
        return buf.toString();
    }

    protected boolean addPrefixDotInToString() {
        return true;
    }

    @Override
    public int compareTo(SnmpObjId o) {
        if (o == null) {
            throw new NullPointerException("o is null");
        }
        SnmpObjId other = o;
        int minLen = Math.min(this.length(), other.length());
        for (int i = 0; i < minLen; ++i) {
            int diff = this.m_ids[i] - other.m_ids[i];
            if (diff == 0) continue;
            return diff;
        }
        return this.length() - other.length();
    }

    public SnmpObjId append(String inst) {
        return this.append(SnmpObjId.convertStringToInts(inst));
    }

    public SnmpObjId append(SnmpObjId inst) {
        return this.append(inst.m_ids);
    }

    public SnmpObjId append(int[] instIds) {
        int[] ids = SnmpObjId.appendArrays(this.m_ids, instIds);
        return new SnmpObjId(ids, false);
    }

    private static int[] appendArrays(int[] objIds, int[] instIds) {
        int[] ids = new int[objIds.length + instIds.length];
        System.arraycopy(objIds, 0, ids, 0, objIds.length);
        System.arraycopy(instIds, 0, ids, objIds.length, instIds.length);
        return ids;
    }

    public static SnmpObjId get(String oid) {
        return new SnmpObjId(oid);
    }

    public static SnmpObjId get(int[] ids) {
        return new SnmpObjId(ids);
    }

    public static SnmpObjId get(SnmpObjId oid) {
        return new SnmpObjId(oid);
    }

    public static SnmpObjId get(String objId, String instance) {
        return new SnmpObjId(objId, instance);
    }

    public static SnmpObjId get(SnmpObjId objId, String instance) {
        return new SnmpObjId(objId, instance);
    }

    public static SnmpObjId get(SnmpObjId objId, SnmpObjId instance) {
        return new SnmpObjId(objId, instance);
    }

    public boolean isPrefixOf(SnmpObjId other) {
        if (other == null || this.length() > other.length()) {
            return false;
        }
        for (int i = 0; i < this.m_ids.length; ++i) {
            if (this.m_ids[i] == other.m_ids[i]) continue;
            return false;
        }
        return true;
    }

    public SnmpInstId getInstance(SnmpObjId base) {
        if (!base.isPrefixOf(this)) {
            return null;
        }
        int[] instanceIds = new int[this.length() - base.length()];
        System.arraycopy(this.m_ids, base.length(), instanceIds, 0, instanceIds.length);
        return new SnmpInstId(instanceIds);
    }

    public int length() {
        return this.m_ids.length;
    }

    public SnmpObjId getPrefix(int length) {
        if (length >= this.length()) {
            throw new IllegalArgumentException("Invalid length: " + length + " is longer than length of ObjId");
        }
        int[] newIds = SnmpObjId.cloneIds(this.m_ids, length);
        return new SnmpObjId(newIds, false);
    }

    public int getSubIdAt(int index) {
        return this.m_ids[index];
    }

    public int getLastSubId() {
        return this.getSubIdAt(this.length() - 1);
    }

    public SnmpObjId decrement() {
        if (this.getLastSubId() == 0) {
            return new SnmpObjId(SnmpObjId.cloneIds(this.m_ids, this.length() - 1), false);
        }
        int[] newIds = SnmpObjId.cloneIds(this.m_ids, this.length());
        int n = newIds.length - 1;
        newIds[n] = newIds[n] - 1;
        return new SnmpObjId(newIds, false);
    }
}

