/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final boolean JAF_PRESENT = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)PathExtensionContentNegotiationStrategy.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(PathExtensionContentNegotiationStrategy.class);
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private boolean useJaf = JAF_PRESENT;

    public PathExtensionContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    public PathExtensionContentNegotiationStrategy() {
        super(null);
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    @Override
    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        if (servletRequest == null) {
            logger.warn((Object)"An HttpServletRequest is required to determine the media type key");
            return null;
        }
        String path = urlPathHelper.getLookupPathForRequest(servletRequest);
        String filename = WebUtils.extractFullFilenameFromUrlPath(path);
        String extension = StringUtils.getFilenameExtension((String)filename);
        return StringUtils.hasText((String)extension) ? extension.toLowerCase(Locale.ENGLISH) : null;
    }

    @Override
    protected void handleMatch(String extension, MediaType mediaType) {
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) {
        MediaType jafMediaType;
        if (this.useJaf && (jafMediaType = JafMediaTypeFactory.getMediaType("file." + extension)) != null && !MediaType.APPLICATION_OCTET_STREAM.equals(jafMediaType)) {
            return jafMediaType;
        }
        return null;
    }

    static {
        urlPathHelper.setUrlDecode(false);
    }

    private static class JafMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = JafMediaTypeFactory.initFileTypeMap();

        private JafMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap initFileTypeMap() {
            ClassPathResource resource = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (resource.exists()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading Java Activation Framework FileTypeMap from " + resource));
                }
                InputStream inputStream = null;
                try {
                    inputStream = resource.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException ex) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Loading default Java Activation Framework FileTypeMap");
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType(mediaType) : null;
        }
    }
}

