/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.springframework.http.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMethodNotSupportedException
extends ServletException {
    private String method;
    private String[] supportedMethods;

    public HttpRequestMethodNotSupportedException(String method) {
        this(method, (String[])null);
    }

    public HttpRequestMethodNotSupportedException(String method, String[] supportedMethods) {
        this(method, supportedMethods, "Request method '" + method + "' not supported");
    }

    public HttpRequestMethodNotSupportedException(String method, Collection<String> supportedMethods) {
        this(method, supportedMethods.toArray(new String[supportedMethods.size()]));
    }

    public HttpRequestMethodNotSupportedException(String method, String msg) {
        this(method, null, msg);
    }

    public HttpRequestMethodNotSupportedException(String method, String[] supportedMethods, String msg) {
        super(msg);
        this.method = method;
        this.supportedMethods = supportedMethods;
    }

    public String getMethod() {
        return this.method;
    }

    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }

    public Set<HttpMethod> getSupportedHttpMethods() {
        LinkedHashSet<HttpMethod> supportedMethods = new LinkedHashSet<HttpMethod>();
        for (String value : this.supportedMethods) {
            supportedMethods.add(HttpMethod.valueOf(value));
        }
        return Collections.unmodifiableSet(supportedMethods);
    }
}

