/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.minion;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.netmgt.model.minion.OnmsMinion;

@Table(name="minions_properties", uniqueConstraints={@UniqueConstraint(columnNames={"id", "key"})})
@Entity
@XmlRootElement(name="property")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OnmsMinionProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="id")
    private Integer m_id;
    @XmlTransient
    private OnmsMinion m_minion;
    @XmlAttribute(name="key")
    private String m_key;
    @XmlValue
    private String m_value;

    public OnmsMinionProperty() {
    }

    public OnmsMinionProperty(OnmsMinion minion, String key, String value) {
        this.m_minion = minion;
        this.m_key = key;
        this.m_value = value;
    }

    @Id
    @SequenceGenerator(name="minionSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="minionSequence")
    @Column(name="id", nullable=false, unique=true)
    public Integer getId() {
        return this.m_id;
    }

    void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="minion_id")
    public OnmsMinion getMinion() {
        return this.m_minion;
    }

    void setMinion(OnmsMinion minion) {
        this.m_minion = minion;
    }

    @Column(name="key", nullable=false)
    public String getKey() {
        return this.m_key;
    }

    void setKey(String key) {
        this.m_key = key;
    }

    @Column(name="value")
    public String getValue() {
        return this.m_value;
    }

    void setValue(String value) {
        this.m_value = value;
    }

    public String toString() {
        return "OnmsMinionProperty [id=" + this.m_id + ", minion=" + this.m_minion.getId() + ", key=" + this.m_key + ", value=" + this.m_value + "]";
    }
}

