/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="lldpLink")
public class LldpLink
implements Serializable {
    private static final long serialVersionUID = 3813247749765614567L;
    private Integer m_id;
    private OnmsNode m_node;
    private LldpPortIdSubType m_lldpPortIdSubType;
    private Integer m_lldpLocalPortNum;
    private Integer m_lldpPortIfindex;
    private String m_lldpPortId;
    private String m_lldpPortDescr;
    private String m_lldpRemChassisId;
    private String m_lldpRemSysname;
    private LldpElement.LldpChassisIdSubType m_lldpRemChassisIdSubType;
    private LldpPortIdSubType m_lldpRemPortIdSubType;
    private String m_lldpRemPortId;
    private String m_lldpRemPortDescr;
    private Date m_lldpLinkCreateTime = new Date();
    private Date m_lldpLinkLastPollTime;

    public LldpLink() {
    }

    public LldpLink(OnmsNode node, Integer localPortNum, Integer portIfIndex, String portId, String portDescr, LldpPortIdSubType portIdSubType, String remChassisId, String remSysname, LldpElement.LldpChassisIdSubType remChassisIdSubType, String remPortId, LldpPortIdSubType remPortIdSubType, String remPortDescr) {
        this.setNode(node);
        this.setLldpLocalPortNum(localPortNum);
        this.setLldpPortIfindex(portIfIndex);
        this.setLldpPortId(portId);
        this.setLldpPortDescr(portDescr);
        this.setLldpPortIdSubType(portIdSubType);
        this.setLldpRemChassisId(remChassisId);
        this.setLldpRemSysname(remSysname);
        this.setLldpRemChassisIdSubType(remChassisIdSubType);
        this.setLldpRemPortId(remPortId);
        this.setLldpRemPortIdSubType(remPortIdSubType);
        this.setLldpRemPortDescr(remPortDescr);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="lldpLocalPortNum", nullable=false)
    public Integer getLldpLocalPortNum() {
        return this.m_lldpLocalPortNum;
    }

    public void setLldpLocalPortNum(Integer lldpLocalPortNum) {
        this.m_lldpLocalPortNum = lldpLocalPortNum;
    }

    @Column(name="lldpPortIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.model.LldpPortIdSubTypeUserType")
    public LldpPortIdSubType getLldpPortIdSubType() {
        return this.m_lldpPortIdSubType;
    }

    public void setLldpPortIdSubType(LldpPortIdSubType lldpPortIdSubType) {
        this.m_lldpPortIdSubType = lldpPortIdSubType;
    }

    @Column(name="lldpPortId", length=256, nullable=false)
    public String getLldpPortId() {
        return this.m_lldpPortId;
    }

    public void setLldpPortId(String lldpPortId) {
        this.m_lldpPortId = lldpPortId;
    }

    @Column(name="lldpPortDescr", length=256, nullable=false)
    public String getLldpPortDescr() {
        return this.m_lldpPortDescr;
    }

    public void setLldpPortDescr(String lldpPortDescr) {
        this.m_lldpPortDescr = lldpPortDescr;
    }

    @Column(name="lldpPortIfindex", nullable=true)
    public Integer getLldpPortIfindex() {
        return this.m_lldpPortIfindex;
    }

    public void setLldpPortIfindex(Integer lldpPortIfindex) {
        this.m_lldpPortIfindex = lldpPortIfindex;
    }

    @Column(name="lldpRemChassisId", length=256, nullable=false)
    public String getLldpRemChassisId() {
        return this.m_lldpRemChassisId;
    }

    public void setLldpRemChassisId(String lldpRemChassisId) {
        this.m_lldpRemChassisId = lldpRemChassisId;
    }

    @Column(name="lldpRemSysname", length=256, nullable=false)
    public String getLldpRemSysname() {
        return this.m_lldpRemSysname;
    }

    public void setLldpRemSysname(String lldpRemSysname) {
        this.m_lldpRemSysname = lldpRemSysname;
    }

    @Column(name="lldpRemChassisIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.model.LldpChassisIdSubTypeUserType")
    public LldpElement.LldpChassisIdSubType getLldpRemChassisIdSubType() {
        return this.m_lldpRemChassisIdSubType;
    }

    public void setLldpRemChassisIdSubType(LldpElement.LldpChassisIdSubType lldpRemChassisIdSubType) {
        this.m_lldpRemChassisIdSubType = lldpRemChassisIdSubType;
    }

    @Column(name="lldpRemPortIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.model.LldpPortIdSubTypeUserType")
    public LldpPortIdSubType getLldpRemPortIdSubType() {
        return this.m_lldpRemPortIdSubType;
    }

    public void setLldpRemPortIdSubType(LldpPortIdSubType lldpRemPortIdSubType) {
        this.m_lldpRemPortIdSubType = lldpRemPortIdSubType;
    }

    @Column(name="lldpRemPortId", length=256, nullable=false)
    public String getLldpRemPortId() {
        return this.m_lldpRemPortId;
    }

    public void setLldpRemPortId(String lldpRemPortId) {
        this.m_lldpRemPortId = lldpRemPortId;
    }

    @Column(name="lldpRemPortDescr", length=256, nullable=false)
    public String getLldpRemPortDescr() {
        return this.m_lldpRemPortDescr;
    }

    public void setLldpRemPortDescr(String lldpRemPortDescr) {
        this.m_lldpRemPortDescr = lldpRemPortDescr;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpLinkCreateTime", nullable=false)
    public Date getLldpLinkCreateTime() {
        return this.m_lldpLinkCreateTime;
    }

    public void setLldpLinkCreateTime(Date lldpLinkCreateTime) {
        this.m_lldpLinkCreateTime = lldpLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpLinkLastPollTime", nullable=false)
    public Date getLldpLinkLastPollTime() {
        return this.m_lldpLinkLastPollTime;
    }

    public void setLldpLinkLastPollTime(Date lldpLinkLastPollTime) {
        this.m_lldpLinkLastPollTime = lldpLinkLastPollTime;
    }

    public void merge(LldpLink link) {
        this.setLldpPortId(link.getLldpPortId());
        this.setLldpPortIdSubType(link.getLldpPortIdSubType());
        this.setLldpPortDescr(link.getLldpPortDescr());
        this.setLldpPortIfindex(link.getLldpPortIfindex());
        this.setLldpRemChassisId(link.getLldpRemChassisId());
        this.setLldpRemChassisIdSubType(link.getLldpRemChassisIdSubType());
        this.setLldpRemSysname(link.getLldpRemSysname());
        this.setLldpRemPortId(link.getLldpRemPortId());
        this.setLldpRemPortIdSubType(link.getLldpRemPortIdSubType());
        this.setLldpRemPortDescr(link.getLldpRemPortDescr());
        this.setLldpLinkLastPollTime(link.getLldpLinkCreateTime());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("NodeId", (Object)this.m_node.getId()).append("lldpLocalPortNum", (Object)this.m_lldpLocalPortNum).append("lldpPortIdSubType", (Object)LldpPortIdSubType.getTypeString(this.m_lldpPortIdSubType.getValue())).append("lldpPortId", (Object)this.m_lldpPortId).append("lldpPortDescr", (Object)this.m_lldpPortDescr).append("lldpPortIfindex", (Object)this.m_lldpPortIfindex).append("lldpRemChassisId", (Object)this.m_lldpRemChassisId).append("lldpRemChassisSubType", (Object)LldpElement.LldpChassisIdSubType.getTypeString(this.m_lldpRemChassisIdSubType.getValue())).append("lldpRemSysname", (Object)this.m_lldpRemSysname).append("lldpRemPortIdSubType", (Object)LldpPortIdSubType.getTypeString(this.m_lldpRemPortIdSubType.getValue())).append("lldpRemPortId", (Object)this.m_lldpRemPortId).append("lldpRemPortDescr", (Object)this.m_lldpRemPortDescr).append("createTime", (Object)this.m_lldpLinkCreateTime).append("lastPollTime", (Object)this.m_lldpLinkLastPollTime).toString();
    }

    public static enum LldpPortIdSubType {
        LLDP_PORTID_SUBTYPE_INTERFACEALIAS(1),
        LLDP_PORTID_SUBTYPE_PORTCOMPONENT(2),
        LLDP_PORTID_SUBTYPE_MACADDRESS(3),
        LLDP_PORTID_SUBTYPE_NETWORKADDRESS(4),
        LLDP_PORTID_SUBTYPE_INTERFACENAME(5),
        LLDP_PORTID_SUBTYPE_AGENTCIRCUITID(6),
        LLDP_PORTID_SUBTYPE_LOCAL(7);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private LldpPortIdSubType(Integer chassisIdsubtype) {
            this.m_type = chassisIdsubtype;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static LldpPortIdSubType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create LldpPortIdSubType from null code");
            }
            switch (code) {
                case 1: {
                    return LLDP_PORTID_SUBTYPE_INTERFACEALIAS;
                }
                case 2: {
                    return LLDP_PORTID_SUBTYPE_PORTCOMPONENT;
                }
                case 3: {
                    return LLDP_PORTID_SUBTYPE_MACADDRESS;
                }
                case 4: {
                    return LLDP_PORTID_SUBTYPE_NETWORKADDRESS;
                }
                case 5: {
                    return LLDP_PORTID_SUBTYPE_INTERFACENAME;
                }
                case 6: {
                    return LLDP_PORTID_SUBTYPE_AGENTCIRCUITID;
                }
                case 7: {
                    return LLDP_PORTID_SUBTYPE_LOCAL;
                }
            }
            throw new IllegalArgumentException("Cannot create LldpPortIdSubType from code " + code);
        }

        public Integer getValue() {
            return this.m_type;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "interfaceAlias");
            s_typeMap.put(2, "portComponent");
            s_typeMap.put(3, "macAddress");
            s_typeMap.put(4, "networkAddress");
            s_typeMap.put(5, "interfaceName");
            s_typeMap.put(6, "agentCircuitId");
            s_typeMap.put(7, "local");
        }
    }
}

