/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="lldpElement")
public final class LldpElement
implements Serializable {
    private static final long serialVersionUID = -3134355798509685991L;
    private Integer m_id;
    private String m_lldpChassisId;
    private String m_lldpSysname;
    private LldpChassisIdSubType m_lldpChassisIdSubType;
    private Date m_lldpNodeCreateTime = new Date();
    private Date m_lldpNodeLastPollTime;
    private OnmsNode m_node;

    public LldpElement() {
    }

    public LldpElement(OnmsNode node, String chassisId, String sysName, LldpChassisIdSubType chassisIdSubType) {
        this.setNode(node);
        this.setLldpChassisId(chassisId);
        this.setLldpSysname(sysName);
        this.setLldpChassisIdSubType(chassisIdSubType);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Column(name="lldpChassisIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.model.LldpChassisIdSubTypeUserType")
    public LldpChassisIdSubType getLldpChassisIdSubType() {
        return this.m_lldpChassisIdSubType;
    }

    @Column(name="lldpSysname", length=256, nullable=false)
    public String getLldpSysname() {
        return this.m_lldpSysname;
    }

    @Column(name="lldpChassisId", length=256, nullable=false)
    public String getLldpChassisId() {
        return this.m_lldpChassisId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpNodeCreateTime", nullable=false)
    public Date getLldpNodeCreateTime() {
        return this.m_lldpNodeCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpNodeLastPollTime", nullable=false)
    public Date getLldpNodeLastPollTime() {
        return this.m_lldpNodeLastPollTime;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public void setLldpSysname(String lldpSysname) {
        this.m_lldpSysname = lldpSysname;
    }

    public void setLldpChassisId(String lldpChassisId) {
        this.m_lldpChassisId = lldpChassisId;
    }

    public void setLldpChassisIdSubType(LldpChassisIdSubType lldpChassisIdSubType) {
        this.m_lldpChassisIdSubType = lldpChassisIdSubType;
    }

    public void setLldpNodeCreateTime(Date lldpNodeCreateTime) {
        this.m_lldpNodeCreateTime = lldpNodeCreateTime;
    }

    public void setLldpNodeLastPollTime(Date lldpNodeLastPollTime) {
        this.m_lldpNodeLastPollTime = lldpNodeLastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Nodeid", this.m_node == null ? null : this.m_node.getId()).append("lldpChassisSubType", (Object)LldpChassisIdSubType.getTypeString(this.m_lldpChassisIdSubType.getValue())).append("lldpChassisId", (Object)this.m_lldpChassisId).append("lldpSysName", (Object)this.m_lldpSysname).append("lldpNodeCreateTime", (Object)this.m_lldpNodeCreateTime).append("lldpNodeLastPollTime", (Object)this.m_lldpNodeLastPollTime).toString();
    }

    public void merge(LldpElement element) {
        if (element == null) {
            return;
        }
        this.setLldpChassisId(element.getLldpChassisId());
        this.setLldpChassisIdSubType(element.getLldpChassisIdSubType());
        this.setLldpSysname(element.getLldpSysname());
        this.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
    }

    public static enum LldpChassisIdSubType {
        LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT(1),
        LLDP_CHASSISID_SUBTYPE_INTERFACEALIAS(2),
        LLDP_CHASSISID_SUBTYPE_PORTCOMPONENT(3),
        LLDP_CHASSISID_SUBTYPE_MACADDRESS(4),
        LLDP_CHASSISID_SUBTYPE_NETWORKADDRESS(5),
        LLDP_CHASSISID_SUBTYPE_INTERFACENAME(6),
        LLDP_CHASSISID_SUBTYPE_LOCAL(7);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private LldpChassisIdSubType(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static LldpChassisIdSubType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create LldpChassisIdSubType from null code");
            }
            switch (code) {
                case 1: {
                    return LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT;
                }
                case 2: {
                    return LLDP_CHASSISID_SUBTYPE_INTERFACEALIAS;
                }
                case 3: {
                    return LLDP_CHASSISID_SUBTYPE_PORTCOMPONENT;
                }
                case 4: {
                    return LLDP_CHASSISID_SUBTYPE_MACADDRESS;
                }
                case 5: {
                    return LLDP_CHASSISID_SUBTYPE_NETWORKADDRESS;
                }
                case 6: {
                    return LLDP_CHASSISID_SUBTYPE_INTERFACENAME;
                }
                case 7: {
                    return LLDP_CHASSISID_SUBTYPE_LOCAL;
                }
            }
            throw new IllegalArgumentException("Cannot create LldpChassisIdSubType from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "chassisComponent");
            s_typeMap.put(2, "interfaceAlias");
            s_typeMap.put(3, "portComponent");
            s_typeMap.put(4, "macAddress");
            s_typeMap.put(5, "networkAddress");
            s_typeMap.put(6, "interfaceName");
            s_typeMap.put(7, "local");
        }
    }
}

