/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class DefaultPollerSettings
implements InitializingBean,
PollerSettings {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPollerSettings.class);
    private static final String MONITOR_ID_KEY = "locationMonitorId";
    private Resource m_configResource;
    private Properties m_settings;

    @Override
    public Integer getMonitorId() {
        String monIdStr = this.m_settings.getProperty(MONITOR_ID_KEY);
        return monIdStr == null ? null : Integer.decode(monIdStr);
    }

    @Override
    public void setMonitorId(Integer monitorId) {
        if (monitorId == null) {
            this.m_settings.remove(MONITOR_ID_KEY);
        } else {
            this.m_settings.setProperty(MONITOR_ID_KEY, monitorId.toString());
        }
        this.save();
    }

    private void save() {
        FileOutputStream out = null;
        try {
            File configFile = this.m_configResource.getFile();
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                LOG.warn("Could not make directory: {}", (Object)configFile.getPath());
            }
            out = new FileOutputStream(configFile);
            this.m_settings.store(out, "Properties File for OpenNMS Remote Poller");
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to save properties to " + this.m_configResource, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setConfigurationResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_configResource, (String)"The configurationDir property must be set");
        this.m_settings = this.m_configResource.exists() ? PropertiesLoaderUtils.loadProperties((Resource)this.m_configResource) : new Properties();
    }
}

