/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.jmx.JmxDefaultTransaction;
import com.atomikos.icatch.admin.jmx.JmxHeuristicTransaction;
import com.atomikos.icatch.admin.jmx.JmxPreparedTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransaction;
import com.atomikos.icatch.admin.jmx.JmxTransactionMBean;
import java.util.ArrayList;

public class JmxTransactionMBeanFactory {
    private static JmxTransactionMBean createMBean(AdminTransaction tx) {
        JmxTransaction ret = null;
        switch (tx.getState()) {
            case 0: {
                ret = new JmxPreparedTransaction(tx);
                break;
            }
            case 2: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 1: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 3: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            case 4: {
                ret = new JmxHeuristicTransaction(tx);
                break;
            }
            default: {
                ret = new JmxDefaultTransaction(tx);
            }
        }
        return ret;
    }

    private static AdminTransaction[] filterHeuristics(AdminTransaction[] txs) {
        ArrayList<AdminTransaction> ret = new ArrayList<AdminTransaction>();
        block6: for (int i = 0; i < txs.length; ++i) {
            AdminTransaction next = txs[i];
            switch (next.getState()) {
                case 2: {
                    ret.add(next);
                    continue block6;
                }
                case 1: {
                    ret.add(next);
                    continue block6;
                }
                case 3: {
                    ret.add(next);
                    continue block6;
                }
                case 4: {
                    ret.add(next);
                    continue block6;
                }
            }
        }
        return ret.toArray(new AdminTransaction[0]);
    }

    public static JmxTransactionMBean[] createMBeans(AdminTransaction[] transactions, boolean heuristicsOnly) {
        ArrayList<JmxTransactionMBean> ret = new ArrayList<JmxTransactionMBean>();
        if (heuristicsOnly) {
            transactions = JmxTransactionMBeanFactory.filterHeuristics(transactions);
        }
        for (AdminTransaction tx : transactions) {
            ret.add(JmxTransactionMBeanFactory.createMBean(tx));
        }
        return ret.toArray(new JmxTransactionMBean[0]);
    }
}

