/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.Querier;
import org.opennms.core.utils.RowProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfLabel {
    private static final Logger LOG = LoggerFactory.getLogger(IfLabel.class);

    public static Map<String, String> getInterfaceInfoFromIfLabel(int nodeId, String ifLabel) {
        if (ifLabel == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        final HashMap info = new HashMap();
        String desc = ifLabel;
        String mac = null;
        int dashIndex = ifLabel.lastIndexOf(45);
        if (dashIndex >= 0) {
            desc = ifLabel.substring(0, dashIndex);
            mac = ifLabel.substring(dashIndex + 1, ifLabel.length());
        }
        final String desc2 = desc;
        final String mac2 = mac;
        LOG.debug("getInterfaceInfoFromIfLabel: desc={} mac={}", (Object)desc, mac);
        String queryDesc = desc.replace('_', '%');
        String query = "SELECT *   FROM snmpinterface  WHERE nodeid = " + nodeId + "   AND (snmpifdescr ILIKE '" + queryDesc + "'" + "    OR snmpifname ilike '" + queryDesc + "')";
        LOG.debug("getInterfaceInfoFromLabel: query is: {}", (Object)query);
        Querier q = new Querier(DataSourceFactory.getInstance(), query, new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                if (rs.getString("snmpifdescr") != null && Pattern.matches(".*-cef.*", rs.getString("snmpifdescr"))) {
                    return;
                }
                if ((AlphaNumeric.parseAndReplace((String)rs.getString("snmpifname"), (char)'_').equals(desc2) || AlphaNumeric.parseAndReplace((String)rs.getString("snmpifdescr"), (char)'_').equals(desc2)) && (mac2 == null || mac2.equals(rs.getString("snmpphysaddr")))) {
                    LOG.debug("getInterfaceInfoFromIfLabel: found match...");
                    for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                        info.put(rs.getMetaData().getColumnName(i), rs.getString(i));
                    }
                }
            }
        });
        q.execute(new Object[0]);
        LOG.debug("getInterfaceInfoFromLabel: Querier result count is: {}", (Object)q.getCount());
        return Collections.unmodifiableMap(info);
    }

    public static String[] getIfLabels(int nodeId) throws SQLException {
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex = snmpifindex    AND ipinterface.nodeid=" + nodeId;
        final ArrayList list = new ArrayList();
        Querier q = new Querier(DataSourceFactory.getInstance(), query, new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                list.add(IfLabel.getIfLabel(name, descr, physAddr));
            }
        });
        q.execute(new Object[0]);
        return list.toArray(new String[list.size()]);
    }

    public static String getIfLabel(final int nodeId, final String ipAddr) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String inetAddr = InetAddressUtils.normalize((String)ipAddr);
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex=snmpifindex    AND ipinterface.nodeid = " + nodeId + "   AND ipinterface.ipaddr = '" + inetAddr + "'";
        Querier q = new Querier(DataSourceFactory.getInstance(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    LOG.warn("Interface (nodeId/ipAddr={}/{}) has no ifName and no ifDescr...setting to label to 'no_ifLabel'.", (Object)nodeId, (Object)ipAddr);
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute(new Object[0]);
        return holder.getLabel();
    }

    public static String getIfLabelfromIfIndex(final int nodeId, final String ipAddr, int ifIndex) {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String inetAddr = InetAddressUtils.normalize((String)ipAddr);
        if (ifIndex == -1) {
            return IfLabel.getIfLabel(nodeId, inetAddr);
        }
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface, ipinterface  WHERE (ipinterface.ismanaged!='D')    AND ipinterface.nodeid=snmpinterface.nodeid    AND ifindex=snmpifindex    AND ipinterface.nodeid= " + nodeId + "   AND ipinterface.ipaddr= '" + inetAddr + "'" + "   AND ipinterface.ifindex= " + ifIndex;
        Querier q = new Querier(DataSourceFactory.getInstance(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    LOG.warn("Interface (nodeId/ipAddr={}/{}) has no ifName and no ifDescr...setting to label to 'no_ifLabel'.", (Object)nodeId, (Object)ipAddr);
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute(new Object[0]);
        return holder.getLabel();
    }

    public static String getIfLabelfromSnmpIfIndex(final int nodeId, final int ifIndex) {
        class LabelHolder {
            private String m_label;

            LabelHolder() {
            }

            public void setLabel(String label) {
                this.m_label = label;
            }

            public String getLabel() {
                return this.m_label;
            }
        }
        final LabelHolder holder = new LabelHolder();
        String query = "SELECT DISTINCT snmpifname, snmpifdescr,snmpphysaddr   FROM snmpinterface    WHERE nodeid= " + nodeId + "   AND snmpifindex= " + ifIndex;
        Querier q = new Querier(DataSourceFactory.getInstance(), query, new RowProcessor(){
            {
            }

            public void processRow(ResultSet rs) throws SQLException {
                String name = rs.getString("snmpifname");
                String descr = rs.getString("snmpifdescr");
                String physAddr = rs.getString("snmpphysaddr");
                if (name != null || descr != null) {
                    holder.setLabel(IfLabel.getIfLabel(name, descr, physAddr));
                } else {
                    LOG.warn("Interface (nodeId/ifIndex={}/{}) has no ifName and no ifDescr...setting to label to 'no_ifLabel'.", (Object)nodeId, (Object)ifIndex);
                    holder.setLabel("no_ifLabel");
                }
            }
        });
        q.execute(new Object[0]);
        return holder.getLabel();
    }

    public static String getIfLabel(String name, String descr, String physAddr) {
        String label = null;
        if (name != null) {
            label = AlphaNumeric.parseAndReplace((String)name, (char)'_');
        } else if (descr != null) {
            label = AlphaNumeric.parseAndReplace((String)descr, (char)'_');
        } else {
            throw new IllegalArgumentException("Both name and descr are null, but at least one cannot be.");
        }
        if (physAddr != null) {
            if ((physAddr = AlphaNumeric.parseAndTrim((String)physAddr)).length() == 12) {
                label = label + "-" + physAddr;
            } else {
                LOG.debug("initialize: physical address len is NOT 12, physAddr={}", (Object)physAddr);
            }
        }
        return label;
    }
}

