/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.ArrayList;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class BroadcastEventProcessor
implements EventListener,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final EventIpcManager m_eventMgr;
    private final TrapdIpMgr m_trapdIpMgr;

    public BroadcastEventProcessor(EventIpcManager eventMgr, TrapdIpMgr trapdIpMgr) {
        this.m_eventMgr = eventMgr;
        this.m_trapdIpMgr = trapdIpMgr;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public TrapdIpMgr getTrapdIpMgr() {
        return this.m_trapdIpMgr;
    }

    public void open() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        this.m_eventMgr.addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        this.m_eventMgr.removeEventListener((EventListener)this);
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"eventManager not set");
        Assert.state((this.m_trapdIpMgr != null ? 1 : 0) != 0, (String)"trapIpMgr not set");
    }

    public void destroy() throws Exception {
        this.close();
    }

    public void onEvent(Event event) {
        String eventUei = event.getUei();
        if (eventUei == null) {
            LOG.warn("Received an unexpected event with a null UEI");
            return;
        }
        LOG.debug("Received event: {}", (Object)eventUei);
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface") || eventUei.equals("uei.opennms.org/nodes/interfaceReparented")) {
            String action;
            String string = action = eventUei.equals("uei.opennms.org/nodes/interfaceReparented") ? "reparent" : "add";
            if (Long.toString(event.getNodeid()) == null) {
                LOG.warn("Not {}ing interface to known node list: nodeId is null", (Object)action);
            } else if (event.getInterface() == null) {
                LOG.warn("Not {}ing interface to known node list: interface is null", (Object)action);
            } else {
                this.m_trapdIpMgr.setNodeId(event.getInterface(), event.getNodeid());
                LOG.debug("Successfully {}ed {} to known node list", (Object)action, (Object)event.getInterface());
            }
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() != null) {
                this.m_trapdIpMgr.removeNodeId(event.getInterface());
                LOG.debug("Removed {} from known node list", (Object)event.getInterface());
            }
        } else {
            LOG.warn("Received an unexpected event with UEI of \"{}\"", (Object)eventUei);
        }
    }

    public String getName() {
        return "Trapd:BroadcastEventProcessor";
    }
}

