/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.rrd.RrdFileConstants;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.threshd.ThresholdingVisitor;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyInterface {
    private static final String RRD_REPOSITORY_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.RrdRepository";
    private static final String THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.ThresholdMap";
    private static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.NodeId";
    private static final Logger LOG = LoggerFactory.getLogger(LatencyInterface.class);
    private NetworkInterface<InetAddress> m_iface;
    private String m_serviceName;

    public LatencyInterface(NetworkInterface<InetAddress> iface, String serviceName) {
        this.m_iface = iface;
        this.m_serviceName = serviceName;
    }

    public NetworkInterface<InetAddress> getNetworkInterface() {
        return this.m_iface;
    }

    Map<String, ThresholdEntity> getThresholdMap() {
        NetworkInterface<InetAddress> iface = this.getNetworkInterface();
        Map thresholdMap = (Map)iface.getAttribute(THRESHOLD_MAP_KEY);
        return Collections.unmodifiableMap(thresholdMap);
    }

    InetAddress getInetAddress() {
        return (InetAddress)this.getNetworkInterface().getAddress();
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    int getNodeId() throws ThresholdingException {
        NetworkInterface<InetAddress> iface = this.getNetworkInterface();
        int nodeId = -1;
        Integer tmp = (Integer)iface.getAttribute(NODE_ID_KEY);
        if (tmp != null) {
            nodeId = tmp;
        }
        if (nodeId == -1) {
            throw new ThresholdingException("Threshold checking failed for " + this.getServiceName() + "/" + this.getHostAddress() + ", missing nodeId.", ThresholdingVisitor.ThresholdingResult.THRESHOLDING_FAILED);
        }
        return nodeId;
    }

    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    File getLatencyDir() throws ThresholdingException {
        String repository = (String)this.getNetworkInterface().getAttribute(RRD_REPOSITORY_KEY);
        LOG.debug("check: rrd repository=", (Object)repository);
        File latencyDir = new File(repository + File.separator + this.getHostAddress());
        if (!latencyDir.exists()) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostAddress() + " does not exist. Threshold checking failed for " + this.getHostAddress(), ThresholdingVisitor.ThresholdingResult.THRESHOLDING_FAILED);
        }
        if (!RrdFileConstants.isValidRRDLatencyDir((File)latencyDir)) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostAddress() + " is not a valid RRD latency directory. Threshold checking failed for " + this.getHostAddress(), ThresholdingVisitor.ThresholdingResult.THRESHOLDING_FAILED);
        }
        return latencyDir;
    }

    Event createEvent(double dsValue, Threshold threshold, String uei, Date date) throws ThresholdingException {
        int nodeId = this.getNodeId();
        InetAddress ipAddr = this.getInetAddress();
        if (threshold == null) {
            throw new IllegalArgumentException("threshold cannot be null.");
        }
        LOG.debug("createEvent: ds={} uei={}", (Object)threshold.getDsName(), (Object)uei);
        EventBuilder bldr = new EventBuilder(uei, "OpenNMS.Threshd:" + threshold.getDsName(), date);
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(ipAddr);
        bldr.setService(this.getServiceName());
        bldr.setHost(InetAddressUtils.getLocalHostName());
        bldr.addParam("ds", threshold.getDsName());
        bldr.addParam("value", dsValue);
        bldr.addParam("threshold", threshold.getValue());
        bldr.addParam("trigger", threshold.getTrigger());
        bldr.addParam("rearm", threshold.getRearm());
        return bldr.getEvent();
    }
}

