/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.List;
import java.util.concurrent.Callable;
import org.opennms.core.concurrent.EndOfTheWaterfall;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.syslogd.ConvertToEvent;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyslogProcessor
implements EndOfTheWaterfall {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogProcessor.class);
    private final boolean m_NewSuspectOnMessage;
    private final String m_localAddr;
    private final ConvertToEvent m_event;

    public SyslogProcessor(ConvertToEvent event) {
        this.m_event = event;
        this.m_NewSuspectOnMessage = SyslogdConfigFactory.getInstance().getNewSuspectOnMessage();
        this.m_localAddr = InetAddressUtils.getLocalHostName();
    }

    public Callable<Void> call() {
        try {
            if (LOG.isTraceEnabled()) {
                List parms;
                LOG.trace("Processing a syslog to event dispatch", (Object)this.m_event.toString());
                String uuid = this.m_event.getEvent().getUuid();
                LOG.trace("Event {");
                LOG.trace("  uuid  = {}", (Object)(uuid != null && uuid.length() > 0 ? uuid : "<not-set>"));
                LOG.trace("  uei   = {}", (Object)this.m_event.getEvent().getUei());
                LOG.trace("  src   = {}", (Object)this.m_event.getEvent().getSource());
                LOG.trace("  iface = {}", (Object)this.m_event.getEvent().getInterface());
                LOG.trace("  time  = {}", (Object)this.m_event.getEvent().getTime());
                LOG.trace("  Msg   = {}", (Object)this.m_event.getEvent().getLogmsg().getContent());
                LOG.trace("  Dst   = {}", (Object)this.m_event.getEvent().getLogmsg().getDest());
                List list = parms = this.m_event.getEvent().getParmCollection() == null ? null : this.m_event.getEvent().getParmCollection();
                if (parms != null) {
                    LOG.trace("  parms {");
                    for (Parm parm : parms) {
                        if (parm.getParmName() == null || parm.getValue().getContent() == null) continue;
                        LOG.trace("    ({}, {})", (Object)parm.getParmName().trim(), (Object)parm.getValue().getContent().trim());
                    }
                    LOG.trace("  }");
                }
                LOG.trace("}");
            }
            EventIpcManagerFactory.getIpcManager().sendNow(this.m_event.getEvent());
            if (this.m_NewSuspectOnMessage && !this.m_event.getEvent().hasNodeid()) {
                LOG.trace("Syslogd: Found a new suspect {}", (Object)this.m_event.getEvent().getInterface());
                SyslogProcessor.sendNewSuspectEvent(this.m_localAddr, this.m_event.getEvent().getInterface());
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected error processing SyslogMessage - Could not send", t);
        }
        return null;
    }

    private static void sendNewSuspectEvent(String localAddr, String trapInterface) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "syslogd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(localAddr);
        EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
    }
}

