/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rfc5424SyslogParser
extends SyslogParser {
    private static final Logger LOG = LoggerFactory.getLogger(Rfc5424SyslogParser.class);
    private static final Pattern m_rfc5424Pattern = Pattern.compile("^<(\\d{1,3})>(\\d{0,2}?) (\\S+T\\S+) (\\S*) (\\S*) (\\d+|-) (\\S*) ((?:\\[.*?\\])*|-)(?: (?:BOM)?(.*?))?$", 8);
    private static final Pattern m_dateWithOffset = Pattern.compile("^(.*[\\-\\+]\\d\\d):?(\\d\\d)$");

    protected Rfc5424SyslogParser(String text) {
        super(text);
    }

    public static SyslogParser getParser(String text) {
        return new Rfc5424SyslogParser(text);
    }

    @Override
    protected Pattern getPattern() {
        return m_rfc5424Pattern;
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        String messageText;
        if (!this.find()) {
            if (this.traceEnabled()) {
                LOG.trace("'{}' did not match '{}'", (Object)m_rfc5424Pattern, (Object)this.getText());
            }
            return null;
        }
        Matcher matcher = this.getMatcher();
        SyslogMessage message = new SyslogMessage();
        try {
            int priorityField = Integer.parseInt(matcher.group(1));
            message.setFacility(SyslogFacility.getFacilityForCode(priorityField));
            message.setSeverity(SyslogSeverity.getSeverityForCode(priorityField));
        }
        catch (NumberFormatException e) {
            LOG.debug("Unable to parse priority field '{}'", (Object)matcher.group(1), (Object)e);
        }
        if (matcher.group(2).length() != 0) {
            try {
                int version = Integer.parseInt(matcher.group(2));
                message.setVersion(version);
            }
            catch (NumberFormatException e) {
                LOG.debug("Unable to parse version ({}) as a number.", (Object)matcher.group(2), (Object)e);
            }
        }
        if (!matcher.group(3).equals("-")) {
            message.setDate(this.parseDate(matcher.group(3)));
        }
        if (!matcher.group(4).equals("-")) {
            message.setHostName(matcher.group(4));
        }
        if (!matcher.group(5).equals("-")) {
            message.setProcessName(matcher.group(5));
        }
        if (!matcher.group(6).equals("-")) {
            try {
                message.setProcessId(Integer.parseInt(matcher.group(6)));
            }
            catch (NumberFormatException e) {
                LOG.debug("Unable to parse process ID '{}' as a number.", (Object)matcher.group(6), (Object)e);
            }
        }
        if (!matcher.group(7).equals("-")) {
            message.setMessageID(matcher.group(7));
        }
        if ((messageText = matcher.group(9)) != null && messageText.length() != 0) {
            message.setMessage(messageText.trim());
        }
        return message;
    }

    @Override
    protected Date parseDate(String dateString) {
        if (dateString.endsWith("Z")) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(dateString);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", Locale.ROOT);
                    df.setLenient(true);
                    df.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return df.parse(dateString);
                }
                catch (Exception pe) {
                    LOG.debug("Unable to parse date string '{}'.", (Object)dateString, (Object)pe);
                }
            }
        } else {
            String newString;
            Matcher matcher = m_dateWithOffset.matcher(dateString);
            if (matcher.find()) {
                newString = matcher.group(1) + matcher.group(2);
            } else {
                String first = dateString.substring(0, dateString.lastIndexOf(45));
                String last = dateString.substring(dateString.lastIndexOf(45));
                newString = first + last.replace(":", "");
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ROOT);
                return df.parse(newString);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ", Locale.ROOT);
                    df.setLenient(true);
                    return df.parse(newString);
                }
                catch (Exception pe) {
                    LOG.debug("Unable to parse date string '{}'.", (Object)newString, (Object)pe);
                }
            }
        }
        return null;
    }
}

