/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.text.ParseException;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.opennms.netmgt.statsd.ReportDefinitionBuilder;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.netmgt.statsd.ReportPersister;
import org.opennms.netmgt.xml.event.Event;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.CronTriggerBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@EventListener(name="OpenNMS:Statsd", logPrefix="statsd")
public class Statsd
implements SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Statsd.class);
    private static final String LOG4J_CATEGORY = "statsd";
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private ResourceDao m_resourceDao;
    @Autowired
    private RrdDao m_rrdDao;
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    private ReportPersister m_reportPersister;
    private Scheduler m_scheduler;
    private ReportDefinitionBuilder m_reportDefinitionBuilder;
    private volatile EventForwarder m_eventForwarder;
    private long m_reportsStarted = 0L;
    private long m_reportsCompleted = 0L;
    private long m_reportsPersisted = 0L;
    private long m_reportRunTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            LOG.info("handleReloadConfigEvent: reloading configuration...");
            EventBuilder ebldr = null;
            LOG.debug("handleReloadConfigEvent: acquiring lock...");
            Scheduler scheduler = this.m_scheduler;
            synchronized (scheduler) {
                try {
                    LOG.debug("handleReloadConfigEvent: lock acquired, unscheduling current reports...");
                    this.unscheduleReports();
                    this.m_reportDefinitionBuilder.reload();
                    LOG.debug("handleReloadConfigEvent: config remarshaled, unscheduling current reports...");
                    LOG.debug("handleReloadConfigEvent: reports unscheduled, rescheduling...");
                    this.start();
                    LOG.debug("handleRelodConfigEvent: reports rescheduled.");
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Statsd");
                    ebldr.addParam("daemonName", "Statsd");
                }
                catch (Throwable exception) {
                    LOG.error("handleReloadConfigurationEvent: Error reloading configuration", exception);
                    ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Statsd");
                    ebldr.addParam("daemonName", "Statsd");
                    ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
                }
                if (ebldr != null) {
                    this.getEventForwarder().sendNow(ebldr.getEvent());
                }
            }
            LOG.debug("handleReloadConfigEvent: lock released.");
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        if ("Statsd".equalsIgnoreCase(EventUtils.getParm(event, "daemonName"))) {
            isTarget = true;
        }
        LOG.debug("isReloadConfigEventTarget: Statsd was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LOG.debug("start: acquiring lock...");
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            LOG.info("start: lock acquired (may have reentered), scheduling Reports...");
            for (ReportDefinition reportDef : this.m_reportDefinitionBuilder.buildReportDefinitions()) {
                LOG.debug("start: scheduling Report: {}", (Object)reportDef);
                this.scheduleReport(reportDef);
            }
            LOG.info("start: {} jobs scheduled.", (Object)this.m_scheduler.getJobNames("DEFAULT").length);
        }
        LOG.debug("start: lock released (unless reentrant).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        LOG.debug("start: acquiring lock...");
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            this.m_scheduler.shutdown();
        }
        LOG.debug("start: lock released (unless reentrant).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleReports() throws Exception {
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            for (ReportDefinition reportDef : this.m_reportDefinitionBuilder.buildReportDefinitions()) {
                this.m_scheduler.deleteJob(reportDef.getDescription(), "DEFAULT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReport(ReportDefinition reportDef) throws ClassNotFoundException, NoSuchMethodException, ParseException, SchedulerException, Exception {
        Scheduler scheduler = this.m_scheduler;
        synchronized (scheduler) {
            MethodInvokingJobDetailFactoryBean jobFactory = new MethodInvokingJobDetailFactoryBean();
            jobFactory.setTargetObject((Object)this);
            jobFactory.setTargetMethod("runReport");
            jobFactory.setArguments(new Object[]{reportDef});
            jobFactory.setConcurrent(false);
            jobFactory.setBeanName(reportDef.getDescription());
            jobFactory.afterPropertiesSet();
            JobDetail jobDetail = jobFactory.getObject();
            CronTriggerBean cronReportTrigger = new CronTriggerBean();
            cronReportTrigger.setBeanName(reportDef.getDescription());
            cronReportTrigger.setJobDetail(jobDetail);
            cronReportTrigger.setCronExpression(reportDef.getCronExpression());
            cronReportTrigger.afterPropertiesSet();
            this.m_scheduler.scheduleJob(cronReportTrigger.getJobDetail(), (Trigger)cronReportTrigger);
            LOG.debug("Schedule report {}", (Object)cronReportTrigger);
        }
    }

    public void runReport(ReportDefinition reportDef) throws Throwable {
        ReportInstance report;
        try {
            report = reportDef.createReport(this.m_nodeDao, this.m_resourceDao, this.m_rrdDao, this.m_filterDao);
        }
        catch (Throwable t) {
            LOG.error("Could not create a report instance for report definition {}", (Object)reportDef, (Object)t);
            throw t;
        }
        this.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                long reportStartTime = System.currentTimeMillis();
                LOG.debug("Starting report {}", (Object)report);
                Statsd.this.accountReportStart();
                report.walk();
                LOG.debug("Completed report {}", (Object)report);
                Statsd.this.accountReportComplete();
                Statsd.this.m_reportPersister.persist(report);
                LOG.debug("Report {} persisted", (Object)report);
                Statsd.this.accountReportPersist();
                Statsd.this.accountReportRunTime(System.currentTimeMillis() - reportStartTime);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao must be set to a non-null value");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"property rrdDao must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_transactionTemplate != null ? 1 : 0) != 0, (String)"property transactionTemplate must be set to a non-null value");
        Assert.state((this.m_reportPersister != null ? 1 : 0) != 0, (String)"property reportPersister must be set to a non-null value");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"property scheduler must be set to a non-null value");
        Assert.state((this.m_reportDefinitionBuilder != null ? 1 : 0) != 0, (String)"property reportDefinitionBuilder must be set to a non-null value");
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"eventForwarder property must be set to a non-null value");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.m_transactionTemplate;
    }

    public ReportPersister getReportPersister() {
        return this.m_reportPersister;
    }

    public void setReportPersister(ReportPersister reportPersister) {
        this.m_reportPersister = reportPersister;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public ReportDefinitionBuilder getReportDefinitionBuilder() {
        return this.m_reportDefinitionBuilder;
    }

    public void setReportDefinitionBuilder(ReportDefinitionBuilder reportDefinitionBuilder) {
        this.m_reportDefinitionBuilder = reportDefinitionBuilder;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    private synchronized void accountReportStart() {
        ++this.m_reportsStarted;
    }

    private synchronized void accountReportComplete() {
        ++this.m_reportsCompleted;
    }

    private synchronized void accountReportPersist() {
        ++this.m_reportsPersisted;
    }

    private synchronized void accountReportRunTime(long runtime) {
        this.m_reportRunTime += runtime;
    }

    public long getReportsStarted() {
        return this.m_reportsStarted;
    }

    public long getReportsCompleted() {
        return this.m_reportsCompleted;
    }

    public long getReportsPersisted() {
        return this.m_reportsPersisted;
    }

    public long getReportRunTime() {
        return this.m_reportRunTime;
    }
}

