/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final FifoQueue<Event> m_execQ;

    BroadcastEventProcessor(FifoQueue<Event> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        try {
            this.m_execQ.add((Object)event);
            LOG.debug("Added event '{}' to scriptd execution queue.", (Object)event.getUei());
        }
        catch (FifoQueueException ex) {
            LOG.error("Failed to add event to scriptd execution queue", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            LOG.error("Failed to add event to scriptd execution queue", (Throwable)ex);
        }
    }

    public String getName() {
        return "Scriptd:BroadcastEventProcessor";
    }
}

