/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.poller.pollables.PollConfig;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableServiceConfig
implements PollConfig,
ScheduleInterval {
    private static final Logger LOG = LoggerFactory.getLogger(PollableServiceConfig.class);
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private PollableService m_service;
    private Map<String, Object> m_parameters = null;
    private Package m_pkg;
    private Timer m_timer;
    private Service m_configService;
    private ServiceMonitor m_serviceMonitor;

    public PollableServiceConfig(PollableService svc, PollerConfig pollerConfig, PollOutagesConfig pollOutagesConfig, Package pkg, Timer timer) {
        this.m_service = svc;
        this.m_pollerConfig = pollerConfig;
        this.m_pollOutagesConfig = pollOutagesConfig;
        this.m_pkg = pkg;
        this.m_timer = timer;
        this.m_configService = this.findService(pkg);
        ServiceMonitor monitor = this.getServiceMonitor();
        monitor.initialize((MonitoredService)this.m_service);
    }

    private synchronized Service findService(Package pkg) {
        for (Service s : this.m_pkg.getServices()) {
            if (!s.getName().equalsIgnoreCase(this.m_service.getSvcName())) continue;
            return s;
        }
        throw new RuntimeException("Service name not part of package!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll() {
        String packageName = null;
        PollableServiceConfig pollableServiceConfig = this;
        synchronized (pollableServiceConfig) {
            packageName = this.m_pkg.getName();
        }
        try {
            ServiceMonitor monitor = this.getServiceMonitor();
            LOG.debug("Polling {} using pkg {}", (Object)packageName, (Object)this.m_service);
            PollStatus result = monitor.poll((MonitoredService)this.m_service, this.getParameters());
            LOG.debug("Finish polling {} using pkg {} result = {}", new Object[]{result, this.m_service, packageName});
            return result;
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception while polling {}. Marking service as DOWN", (Object)this.m_service, (Object)e);
            return PollStatus.down((String)("Unexpected exception while polling " + this.m_service + ". " + e));
        }
    }

    private synchronized ServiceMonitor getServiceMonitor() {
        if (this.m_serviceMonitor == null) {
            ServiceMonitor monitor = this.m_pollerConfig.getServiceMonitor(this.m_service.getSvcName());
            this.m_serviceMonitor = new LatencyStoringServiceMonitorAdaptor(monitor, this.m_pollerConfig, this.m_pkg);
        }
        return this.m_serviceMonitor;
    }

    void setServiceMonitor(ServiceMonitor serviceMonitor) {
        this.m_serviceMonitor = serviceMonitor;
    }

    @Override
    public synchronized void refresh() {
        Package newPkg = this.m_pollerConfig.getPackage(this.m_pkg.getName());
        if (newPkg == null) {
            LOG.warn("Package named {} no longer exists.", (Object)this.m_pkg.getName());
        }
        this.m_pkg = newPkg;
        this.m_configService = this.findService(this.m_pkg);
        this.m_parameters = null;
    }

    @Override
    public synchronized void refreshThresholds() {
        ((LatencyStoringServiceMonitorAdaptor)this.getServiceMonitor()).refreshThresholds();
    }

    private synchronized Map<String, Object> getParameters() {
        if (this.m_parameters == null) {
            this.m_parameters = this.createParameterMap(this.m_configService);
        }
        return this.m_parameters;
    }

    private Map<String, Object> createParameterMap(Service svc) {
        ConcurrentSkipListMap<String, Object> m = new ConcurrentSkipListMap<String, Object>();
        for (Parameter p : svc.getParameters()) {
            Object val = p.getValue();
            if (val == null) {
                val = p.getAnyObject() == null ? "" : p.getAnyObject();
            }
            m.put(p.getKey(), val);
        }
        return m;
    }

    @Override
    public long getCurrentTime() {
        return this.m_timer.getCurrentTime();
    }

    @Override
    public synchronized long getInterval() {
        if (this.m_service.isDeleted()) {
            return -1L;
        }
        long when = this.m_configService.getInterval();
        if (this.m_service.getStatus().isDown()) {
            long downSince = this.m_timer.getCurrentTime() - this.m_service.getStatusChangeTime();
            boolean matched = false;
            for (Downtime dt : this.m_pkg.getDowntimes()) {
                if (dt.getBegin() > downSince) continue;
                if (dt.getDelete() != null && (dt.getDelete().equals("yes") || dt.getDelete().equals("true"))) {
                    when = -1L;
                    matched = true;
                    continue;
                }
                if (dt.getEnd() != null && dt.getEnd() > downSince) {
                    when = dt.getInterval();
                    matched = true;
                    continue;
                }
                when = dt.getInterval();
                matched = true;
            }
            if (!matched) {
                LOG.error("Downtime model is invalid on package " + this.m_pkg.getName() + ", cannot schedule service " + this.m_service);
                return -1L;
            }
        }
        if (when < 0L) {
            this.m_service.sendDeleteEvent();
        }
        return when;
    }

    @Override
    public synchronized boolean scheduledSuspension() {
        long nodeId = this.m_service.getNodeId();
        for (String outageName : this.m_pkg.getOutageCalendars()) {
            if (!this.m_pollOutagesConfig.isTimeInOutage(this.m_timer.getCurrentTime(), outageName) || !this.m_pollOutagesConfig.isNodeIdInOutage(nodeId, outageName) && !this.m_pollOutagesConfig.isInterfaceInOutage(this.m_service.getIpAddr(), outageName) && !this.m_pollOutagesConfig.isInterfaceInOutage("match-any", outageName)) continue;
            LOG.debug("scheduledOutage: configured outage '{}' applies, {} will not be polled.", (Object)outageName, (Object)this.m_configService);
            return true;
        }
        return false;
    }
}

