/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollableNetwork
extends PollableContainer {
    private final PollContext m_context;

    public PollableNetwork(PollContext context) {
        super(null, Scope.NETWORK);
        this.m_context = context;
    }

    @Override
    public PollContext getContext() {
        return this.m_context;
    }

    public PollableNode createNode(int nodeId, String nodeLabel) {
        PollableNode node = new PollableNode(this, nodeId, nodeLabel);
        this.addMember(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollableNode createNodeIfNecessary(int nodeId, String nodeLabel) {
        PollableNetwork pollableNetwork = this;
        synchronized (pollableNetwork) {
            PollableNode node = this.getNode(nodeId);
            return node != null ? node : this.createNode(nodeId, nodeLabel);
        }
    }

    public PollableNode getNode(int nodeId) {
        return (PollableNode)this.getMember(nodeId);
    }

    public int getNodeCount() {
        return this.getMemberCount();
    }

    public PollableInterface createInterface(int nodeId, String nodeLabel, InetAddress addr) {
        return this.createNodeIfNecessary(nodeId, nodeLabel).createInterface(addr);
    }

    public PollableInterface getInterface(int nodeId, InetAddress addr) {
        PollableNode node = this.getNode(nodeId);
        return node == null ? null : node.getInterface(addr);
    }

    public PollableService createService(int nodeId, String nodeLabel, InetAddress addr, String svcName) {
        return this.createNodeIfNecessary(nodeId, nodeLabel).createService(addr, svcName);
    }

    public PollableService getService(int nodeId, InetAddress addr, String svcName) {
        PollableNode node = this.getNode(nodeId);
        return node == null ? null : node.getService(addr, svcName);
    }

    @Override
    protected Object createMemberKey(PollableElement member) {
        PollableNode node = (PollableNode)member;
        return node.getNodeId();
    }

    @Override
    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitNetwork(this);
    }

    @Override
    public PollStatus pollRemainingMembers(PollableElement member) {
        return this.getMemberStatus();
    }

    @Override
    public Event createDownEvent(Date date) {
        throw new UnsupportedOperationException("No down event for the network");
    }

    @Override
    public Event createUpEvent(Date date) {
        throw new UnsupportedOperationException("No up event for the network");
    }

    public void dump() {
        DumpVisitor dumper = new DumpVisitor();
        this.visit(dumper);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Can't delete the entire network");
    }

    @Override
    public PollStatus poll(PollableElement elem) {
        PollableElement member = this.findMemberWithDescendent(elem);
        return member.poll(elem);
    }

    @Override
    public void processStatusChange(Date date) {
        this.processMemberStatusChanges(date);
    }

    @Override
    public void recalculateStatus() {
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.recalculateStatus();
            }
        };
        this.forEachMember(iter);
    }

    @Override
    public void resetStatusChanged() {
        super.resetStatusChanged();
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.resetStatusChanged();
            }
        };
        this.forEachMember(iter);
    }

    @Override
    public PollableElement getLockRoot() {
        return this;
    }

    @Override
    public void obtainTreeLock(long timeout) {
    }

    @Override
    public void releaseTreeLock() {
    }

    @Override
    public PollEvent extrapolateCause() {
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.extrapolateCause();
            }
        };
        this.forEachMember(iter);
        return null;
    }

    public void propagateInitialCause() {
        this.extrapolateCause();
        this.inheritParentalCause();
    }

    static class DumpVisitor
    extends PollableVisitorAdaptor {
        private static final Logger LOG = LoggerFactory.getLogger(DumpVisitor.class);

        DumpVisitor() {
        }

        @Override
        public void visitNode(PollableNode pNode) {
            LOG.debug(" nodeid={} status={}", (Object)pNode.getNodeId(), (Object)this.getStatusString(pNode));
        }

        @Override
        public void visitInterface(PollableInterface pIf) {
            LOG.debug("     interface={} status={}", (Object)pIf.getIpAddr(), (Object)this.getStatusString(pIf));
        }

        @Override
        public void visitService(PollableService pSvc) {
            LOG.debug("         service={} status={}", (Object)pSvc.getSvcName(), (Object)this.getStatusString(pSvc));
        }

        private String getStatusString(PollableElement e) {
            PollStatus status = e.getStatus();
            boolean up = status.isUp();
            String statusDesc = status.toString();
            PollEvent cause = e.getCause();
            int eventId = cause == null ? 0 : cause.getEventId();
            return up ? statusDesc : statusDesc + "(" + eventId + ")";
        }
    }
}

