/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.Scope;

public abstract class PollableContainer
extends PollableElement {
    private final Map<Object, PollableElement> m_members = new HashMap<Object, PollableElement>();

    public PollableContainer(PollableContainer parent, Scope scope) {
        super(parent, scope);
    }

    protected synchronized PollableElement getMember(Object key) {
        return this.m_members.get(key);
    }

    protected synchronized int getMemberCount() {
        return this.m_members.size();
    }

    protected synchronized Collection<PollableElement> getMembers() {
        return new ArrayList<PollableElement>(this.m_members.values());
    }

    protected abstract Object createMemberKey(PollableElement var1);

    protected synchronized void addMember(PollableElement member) {
        Object key = this.createMemberKey(member);
        this.m_members.put(key, member);
    }

    public synchronized void removeMember(PollableElement member) {
        Object key = this.createMemberKey(member);
        this.m_members.remove(key);
    }

    public void deleteMember(PollableElement member) {
        this.removeMember(member);
        if (this.m_members.size() == 0) {
            this.delete();
        }
    }

    @Override
    public void delete() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Collection<PollableElement> members = PollableContainer.this.getMembers();
                for (PollableElement member : members) {
                    member.delete();
                }
                PollableContainer.super.delete();
            }
        };
        this.withTreeLock(r);
    }

    @Override
    public void visit(PollableVisitor v) {
        this.visitThis(v);
        this.visitMembers(v);
    }

    @Override
    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitContainer(this);
    }

    protected void visitMembers(PollableVisitor v) {
        for (PollableElement element : this.getMembers()) {
            element.visit(v);
        }
    }

    protected void forEachMember(Iter iter) {
        this.forEachMember(false, iter);
    }

    protected <T> T deriveValueFromMembers(SimpleIter<T> iter) {
        return this.deriveValueFromMembers(false, iter);
    }

    protected <T> T deriveValueFromMembers(boolean withTreeLock, SimpleIter<T> iter) {
        this.forEachMember(withTreeLock, iter);
        return iter.getResult();
    }

    protected void forEachMember(boolean withTreeLock, final Iter iter) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (PollableElement element : PollableContainer.this.getMembers()) {
                    iter.forEachElement(element);
                }
            }
        };
        if (withTreeLock) {
            this.withTreeLock(r);
        } else {
            r.run();
        }
    }

    @Override
    public void recalculateStatus() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SimpleIter<PollStatus> iter = new SimpleIter<PollStatus>(PollStatus.down()){

                    @Override
                    public void forEachElement(PollableElement elem) {
                        elem.recalculateStatus();
                        if (elem.getStatus().isUp()) {
                            this.setResult(PollStatus.up());
                        }
                    }
                };
                PollableContainer.this.forEachMember(iter);
                PollableContainer.this.updateStatus((PollStatus)iter.getResult());
            }
        };
        this.withTreeLock(r);
    }

    @Override
    public void resetStatusChanged() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableContainer.super.resetStatusChanged();
                Iter iter = new Iter(){

                    @Override
                    public void forEachElement(PollableElement elem) {
                        elem.resetStatusChanged();
                    }
                };
                PollableContainer.this.forEachMember(iter);
            }
        };
        this.withTreeLock(r);
    }

    PollableElement findMemberWithDescendent(PollableElement elem) {
        PollableElement member;
        for (member = elem; member != null && member.getParent() != this; member = member.getParent()) {
        }
        return member;
    }

    @Override
    protected PollStatus poll(final PollableElement elem) {
        final PollStatus[] retVal = new PollStatus[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PollableElement member = PollableContainer.this.findMemberWithDescendent(elem);
                PollStatus memberStatus = member.poll(elem);
                if (memberStatus.isUp() != PollableContainer.this.getStatus().isUp() && member.isStatusChanged()) {
                    PollableContainer.this.updateStatus(PollableContainer.this.pollRemainingMembers(member));
                }
                retVal[0] = PollableContainer.this.getStatus();
            }
        };
        elem.withTreeLock(r);
        return retVal[0];
    }

    public PollStatus pollRemainingMembers(final PollableElement member) {
        SimpleIter<PollStatus> iter = new SimpleIter<PollStatus>(member.getStatus()){

            @Override
            public void forEachElement(PollableElement elem) {
                if (elem != member && elem.poll().isUp()) {
                    this.setResult(PollStatus.up());
                }
            }
        };
        this.forEachMember(iter);
        return (PollStatus)iter.getResult();
    }

    public PollStatus getMemberStatus() {
        SimpleIter<PollStatus> iter = new SimpleIter<PollStatus>(PollStatus.down()){

            @Override
            public void forEachElement(PollableElement elem) {
                if (elem.getStatus().isUp()) {
                    this.setResult(PollStatus.up());
                }
            }
        };
        this.forEachMember(iter);
        return (PollStatus)iter.getResult();
    }

    @Override
    public PollStatus poll() {
        PollableElement leaf = this.selectPollElement();
        if (leaf == null) {
            return PollStatus.up();
        }
        return this.poll(leaf);
    }

    @Override
    public PollableElement selectPollElement() {
        if (this.getMemberCount() == 0) {
            return null;
        }
        PollableElement member = this.getMembers().iterator().next();
        return member.selectPollElement();
    }

    @Override
    public void processStatusChange(final Date date) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (PollableContainer.this.isStatusChanged()) {
                    PollableContainer.super.processStatusChange(date);
                } else if (PollableContainer.this.getStatus().isUp()) {
                    PollableContainer.this.processMemberStatusChanges(date);
                }
            }
        };
        this.withTreeLock(r);
    }

    public void processMemberStatusChanges(final Date date) {
        Iter iter = new Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.processStatusChange(date);
            }
        };
        this.forEachMember(iter);
    }

    @Override
    protected void processResolution(PollEvent resolvedCause, PollEvent resolution) {
        super.processResolution(resolvedCause, resolution);
        this.processLingeringMemberCauses(resolvedCause, resolution);
    }

    private void processLingeringMemberCauses(final PollEvent resolvedCause, final PollEvent resolution) {
        Iter iter = new Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.processLingeringCauses(resolvedCause, resolution);
            }
        };
        this.forEachMember(iter);
    }

    @Override
    protected void processCause(final PollEvent cause) {
        super.processCause(cause);
        Iter iter = new Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                elem.processCause(cause);
            }
        };
        this.forEachMember(iter);
    }

    @Override
    protected void resolveAllOutages(final PollEvent resolvedCause, final PollEvent resolution) {
        super.resolveAllOutages(resolvedCause, resolution);
        Iter iter = new Iter(){

            @Override
            public void forEachElement(PollableElement elem) {
                if (!PollableContainer.this.hasOpenOutage()) {
                    elem.resolveAllOutages(resolvedCause, resolution);
                }
            }
        };
        this.forEachMember(iter);
    }

    @Override
    protected PollEvent doExtrapolateCause() {
        PollEvent cause = this.extrapolateMemberCauseWithLargestScope();
        this.setCause(cause);
        if (cause != null) {
            this.updateStatus(PollStatus.down());
        }
        return cause;
    }

    private PollEvent extrapolateMemberCauseWithLargestScope() {
        PollEvent cause = null;
        for (PollableElement member : this.getMembers()) {
            PollEvent memberCause = member.extrapolateCause();
            if (memberCause == null || memberCause.hasScopeSmallerThan(this.getScope())) continue;
            cause = PollEvent.withLargestScope(cause, memberCause);
        }
        return cause;
    }

    @Override
    protected void doInheritParentalCause() {
        super.doInheritParentalCause();
        for (PollableElement member : this.getMembers()) {
            member.inheritParentalCause();
        }
    }

    protected abstract class Accumulator<T>
    extends SimpleIter<T> {
        public Accumulator(T initial) {
            super(initial);
        }

        public Accumulator() {
            super(null);
        }

        @Override
        public void forEachElement(PollableElement element) {
            this.setResult(this.processNextMember(element, this.getResult()));
        }

        abstract T processNextMember(PollableElement var1, T var2);
    }

    protected abstract class SimpleIter<T>
    implements Iter {
        private T result;

        public SimpleIter(T initial) {
            this.result = initial;
        }

        public SimpleIter() {
            this(null);
        }

        public T getResult() {
            return this.result;
        }

        public void setResult(T newResult) {
            this.result = newResult;
        }
    }

    protected static interface Iter {
        public void forEachElement(PollableElement var1);
    }
}

