/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.nrpe;

import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import org.opennms.netmgt.poller.nrpe.NrpePacket;

public class CheckNrpe {
    public static final int DEFAULT_PORT = 5666;
    public static final int DEFAULT_TIMEOUT = 10;
    private static final String s_usage = "Usage: java CheckNrpe -H <host> [-p <port>] [-P <padding>] \\\n                      [-t <timeout>] [-c <command>] [-a <arglist ...>]\nNote: if the -a option is specified it *must* be the last option\n";

    public static NrpePacket executeQuery(String host, String buffer) throws Exception {
        return CheckNrpe.executeQuery(host, 5666, buffer, 2);
    }

    public static NrpePacket executeQuery(String host, String buffer, int padding) throws Exception {
        return CheckNrpe.executeQuery(host, 5666, buffer, padding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NrpePacket executeQuery(String host, int port, String buffer, int padding) throws Exception {
        NrpePacket p = new NrpePacket(1, 0, buffer);
        byte[] b = p.buildPacket(padding);
        Socket s = new Socket(host, port);
        OutputStream o = s.getOutputStream();
        o.write(b);
        try {
            NrpePacket nrpePacket = NrpePacket.receivePacket(s.getInputStream(), padding);
            return nrpePacket;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NrpePacket sendPacket(short type, short resultCode, String buffer) throws Exception {
        int padding = 2;
        NrpePacket p = new NrpePacket(type, resultCode, buffer);
        byte[] b = p.buildPacket(padding);
        Socket s = new Socket("localhost", 5666);
        OutputStream o = s.getOutputStream();
        o.write(b);
        try {
            NrpePacket nrpePacket = NrpePacket.receivePacket(s.getInputStream(), padding);
            return nrpePacket;
        }
        finally {
            s.close();
        }
    }

    public static void main(String[] argv) throws Exception {
        String host = null;
        int port = 5666;
        int padding = 2;
        int timeout = 10;
        String command = "_NRPE_CHECK";
        LinkedList<String> arglist = new LinkedList<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-h")) {
                System.out.print(s_usage);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-H")) {
                host = CheckNrpe.nextArg(argv, ++i);
                continue;
            }
            if (argv[i].equals("-p")) {
                port = Integer.parseInt(CheckNrpe.nextArg(argv, ++i));
                continue;
            }
            if (argv[i].equals("-P")) {
                padding = Integer.parseInt(CheckNrpe.nextArg(argv, ++i));
                continue;
            }
            if (argv[i].equals("-t")) {
                timeout = Integer.parseInt(CheckNrpe.nextArg(argv, ++i));
                continue;
            }
            if (argv[i].equals("-c")) {
                command = CheckNrpe.nextArg(argv, ++i);
                continue;
            }
            if (argv[i].equals("-a")) {
                arglist.add(CheckNrpe.nextArg(argv, ++i));
                continue;
            }
            if (argv[i].startsWith("-")) {
                throw new Exception("Unknown option \"" + argv[i] + "\".  " + "Use \"-h\" option for help.");
            }
            throw new Exception("No non-option arguments are allowed.  Use \"-h\" option for help.");
        }
        if (host == null) {
            throw new Exception("You must specify a -H option.  Use \"-h\" option for help.");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(command);
        Iterator i = arglist.iterator();
        while (i.hasNext()) {
            buffer.append(" ");
            buffer.append((String)i.next());
        }
        NrpePacket p = CheckNrpe.executeQuery(host, port, buffer.toString(), padding);
        System.out.println(p.getBuffer());
        System.exit(p.getResultCode());
    }

    public static String nextArg(String[] argv, int i) throws Exception {
        if (i >= argv.length) {
            throw new Exception("No more command-line arguments but option requires an argument.  Use \"-h\" for help.");
        }
        return argv[i];
    }
}

