/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Distributable(value={DistributionContext.DAEMON})
public class CiscoPingMibMonitor
extends SnmpMonitorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CiscoPingMibMonitor.class);
    private static NodeDao s_nodeDao = null;
    private static final String SERVICE_NAME = "CiscoPing";
    private static final int DEFAULT_TIMEOUT = 1800;
    private static final int DEFAULT_RETRY = 1;
    private static final String PING_ENTRY_OID = ".1.3.6.1.4.1.9.9.16.1.1.1";
    private static final String PING_SERIAL = "1";
    private static final String PING_PROTOCOL = "2";
    private static final String PING_ADDRESS = "3";
    private static final String PING_PACKET_COUNT = "4";
    private static final String PING_PACKET_SIZE = "5";
    private static final String PING_PACKET_TIMEOUT = "6";
    private static final String PING_DELAY = "7";
    private static final String PING_SENT_PACKETS = "9";
    private static final String PING_RECEIVED_PACKETS = "10";
    private static final String PING_MIN_RTT = "11";
    private static final String PING_AVG_RTT = "12";
    private static final String PING_MAX_RTT = "13";
    private static final String PING_COMPLETED = "14";
    private static final String PING_ENTRY_OWNER = "15";
    private static final String PING_ENTRY_STATUS = "16";
    private static final String PING_VRF_NAME = "17";
    private static final int ROWSTATUS_ACTIVE = 1;
    private static final int ROWSTATUS_NOT_IN_SERVICE = 2;
    private static final int ROWSTATUS_NOT_READY = 3;
    private static final int ROWSTATUS_CREATE_AND_GO = 4;
    private static final int ROWSTATUS_CREATE_WAIT = 5;
    private static final int ROWSTATUS_DESTROY = 6;
    private static final int PING_PROTOCOL_IPV4 = 1;
    private static final int PING_PROTOCOL_IPV6 = 20;
    private static final String PARM_PACKET_COUNT = "packet-count";
    private static final int PARM_PACKET_COUNT_DEFAULT = 5;
    private static final String PARM_PACKET_SIZE = "packet-size";
    private static final int PARM_PACKET_SIZE_DEFAULT = 100;
    private static final String PARM_PACKET_TIMEOUT = "packet-timeout";
    private static final int PARM_PACKET_TIMEOUT_DEFAULT = 2000;
    private static final String PARM_PACKET_DELAY = "packet-delay";
    private static final int PARM_PACKET_DELAY_DEFAULT = 0;
    private static final String PARM_ENTRY_OWNER = "entry-owner";
    private static final String PARM_ENTRY_OWNER_DEFAULT = "OpenNMS CiscoPingMibMonitor";
    private static final String PARM_VRF_NAME = "vrf-name";
    private static final String PARM_VRF_NAME_DEFAULT = "";
    private static final String PARM_CLEANUP_INTERVAL = "cleanup-interval";
    private static final int PARM_CLEANUP_INTERVAL_DEFAULT = 86400000;
    private static final String PARM_PROXY_NODE_ID = "proxy-node-id";
    private static final String PARM_PROXY_FOREIGN_SOURCE = "proxy-node-foreign-source";
    private static final String PARM_PROXY_FOREIGN_ID = "proxy-node-foreign-id";
    private static final String PARM_PROXY_IP_ADDR = "proxy-ip-addr";
    private static final String PARM_TARGET_IP_ADDR = "target-ip-addr";
    private static final String PARM_SUCCESS_PERCENT = "success-percent";
    private static final int PARM_SUCCESS_PERCENT_DEFAULT = 100;

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (Throwable ex) {
            LOG.error("initialize: Failed to load SNMP configuration", ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        if (s_nodeDao == null) {
            s_nodeDao = (NodeDao)((ClassPathXmlApplicationContext)BeanUtils.getFactory((String)"commonContext", ClassPathXmlApplicationContext.class)).getBean("nodeDao");
        }
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        InetAddress targetIpAddr = this.determineTargetAddress(svc, parameters);
        int pingProtocol = 0;
        try {
            pingProtocol = this.determineAddrType(targetIpAddr);
        }
        catch (RuntimeException e) {
            LOG.debug("Unknown address type - neither IPv4 nor IPv6", (Throwable)e);
            return PollStatus.unavailable((String)"Unknown address type - neither IPv4 nor IPv6");
        }
        CiscoPingEntry pingEntry = new CiscoPingEntry();
        pingEntry.setCiscoPingPacketCount(ParameterMap.getKeyedInteger(parameters, (String)PARM_PACKET_COUNT, (int)5));
        pingEntry.setCiscoPingPacketSize(ParameterMap.getKeyedInteger(parameters, (String)PARM_PACKET_SIZE, (int)100));
        pingEntry.setCiscoPingPacketTimeout(ParameterMap.getKeyedInteger(parameters, (String)PARM_PACKET_TIMEOUT, (int)2000));
        pingEntry.setCiscoPingPacketDelay(ParameterMap.getKeyedInteger(parameters, (String)PARM_PACKET_DELAY, (int)0));
        pingEntry.setCiscoPingEntryOwner(ParameterMap.getKeyedString(parameters, (String)PARM_ENTRY_OWNER, (String)PARM_ENTRY_OWNER_DEFAULT));
        pingEntry.setCiscoPingVrfName(ParameterMap.getKeyedString(parameters, (String)PARM_VRF_NAME, (String)PARM_VRF_NAME_DEFAULT));
        pingEntry.setCiscoPingSerialNumber(Double.valueOf(System.currentTimeMillis() / 1000L).intValue());
        pingEntry.setCiscoPingProtocol(pingProtocol);
        pingEntry.setCiscoPingAddress(targetIpAddr);
        pingEntry.setCiscoPingEntryStatus(4);
        int minSuccessPercent = ParameterMap.getKeyedInteger(parameters, (String)PARM_SUCCESS_PERCENT, (int)100);
        InetAddress proxyIpAddr = this.determineProxyAddress(parameters, svc);
        if (proxyIpAddr == null) {
            LOG.debug("Unable to determine proxy address for this service");
            return PollStatus.unavailable((String)"Unable to determine proxy address for this service");
        }
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(proxyIpAddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for proxy-ping interface " + proxyIpAddr);
        }
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)proxyIpAddr.getHostAddress());
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("Setting up CISCO-PING-MIB proxy poll for service {} on interface {} -- {}", new Object[]{svc.getSvcName(), targetIpAddr, pingEntry});
        PollStatus serviceStatus = null;
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 1, 1800);
        SnmpValue[] setResult = SnmpUtils.set((SnmpAgentConfig)agentConfig, (SnmpObjId[])pingEntry.generateCreateOids(), (SnmpValue[])pingEntry.generateCreateValues());
        if (setResult == null) {
            LOG.warn("SNMP SET operation unsuccessful for proxy-ping entry for target {} -- {}", (Object)targetIpAddr, (Object)pingEntry);
            return PollStatus.unknown((String)("SNMP SET failed for ciscoPingTable entry on proxy interface " + proxyIpAddr + " with instance ID " + pingEntry.getCiscoPingSerialNumber()));
        }
        try {
            Thread.sleep(pingEntry.calculateMinInitialWait() * 2);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        SnmpValue[] statusValues = null;
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry() && (statusValues == null || statusValues.length < 6 || statusValues[5].toInt() != 1)) {
            statusValues = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])pingEntry.generateResultsOids());
            timeoutTracker.nextAttempt();
        }
        if (statusValues == null || statusValues.length == 1 && statusValues[0] == null) {
            LOG.warn("SNMP GET operation unsuccessful for proxy-ping entry for target {} -- {}", (Object)targetIpAddr, (Object)pingEntry);
            return PollStatus.unknown((String)("SNMP GET failed for ciscoPingTable entry on proxy interface " + proxyIpAddr + " with instance ID " + pingEntry.getCiscoPingSerialNumber()));
        }
        if (statusValues.length < 6) {
            LOG.warn("Proxy-ping entry did not indicate whether ping completed after retries exhausted for target {} -- {}", (Object)targetIpAddr, (Object)pingEntry);
            return PollStatus.unknown((String)("ciscoPingTable entry is missing pingCompleted column on proxy interface " + proxyIpAddr + " with instance ID " + pingEntry.getCiscoPingSerialNumber()));
        }
        if (statusValues[5].toInt() != 1) {
            LOG.warn("Proxy-ping entry marked not completed after retries exhausted for target {} -- {}", (Object)targetIpAddr, (Object)pingEntry);
            return PollStatus.unknown((String)("ciscoPingTable entry marked not completed on proxy interface " + proxyIpAddr + " with instance ID " + pingEntry.getCiscoPingSerialNumber()));
        }
        double sentPings = statusValues[0].toInt();
        double receivedPings = statusValues[1].toInt();
        double successPct = receivedPings / sentPings * 100.0;
        if (receivedPings == 0.0) {
            LOG.info("Proxy-ping entry indicates no pings succeeded for target {} -- {}", (Object)targetIpAddr, (Object)pingEntry);
            this.cleanupCurrentEntry(pingEntry, proxyIpAddr, agentConfig);
            return PollStatus.unavailable((String)("All remote pings (" + sentPings + " of " + sentPings + ") failed"));
        }
        if (successPct < (double)minSuccessPercent) {
            LOG.info("Proxy-ping entry indicates {}% success, which misses the success-percent target of {}% for target {} -- {}", new Object[]{successPct, minSuccessPercent, targetIpAddr, pingEntry});
            this.cleanupCurrentEntry(pingEntry, proxyIpAddr, agentConfig);
            return PollStatus.unavailable((String)(successPct + " percent (" + receivedPings + "/" + sentPings + ") pings succeeded, less than target " + minSuccessPercent + " percent"));
        }
        HashMap<String, Double> pingProps = new HashMap<String, Double>();
        double minRtt = statusValues[2].toInt();
        double avgRtt = statusValues[3].toInt();
        double maxRtt = statusValues[4].toInt();
        LOG.debug("Logging successful poll: sent={}, received={}, minRtt={}, avgRtt={}, maxRtt={} for proxy-ping of target {} -- {}", new Object[]{sentPings, receivedPings, minRtt, avgRtt, maxRtt, targetIpAddr, pingEntry});
        pingProps.put("sent", sentPings);
        pingProps.put("received", receivedPings);
        pingProps.put("minRtt", minRtt);
        pingProps.put("avgRtt", avgRtt);
        pingProps.put("maxRtt", maxRtt);
        this.cleanupCurrentEntry(pingEntry, proxyIpAddr, agentConfig);
        serviceStatus = PollStatus.available((Double)avgRtt);
        serviceStatus.setProperties(pingProps);
        return serviceStatus;
    }

    private void cleanupCurrentEntry(CiscoPingEntry pingEntry, InetAddress proxyIpAddr, SnmpAgentConfig agentConfig) {
        pingEntry.setCiscoPingEntryStatus(6);
        SnmpValue[] destroyValues = SnmpUtils.set((SnmpAgentConfig)agentConfig, (SnmpObjId[])pingEntry.generateRowStatusOids(), (SnmpValue[])pingEntry.generateRowStatusValues());
        if (destroyValues == null) {
            LOG.warn("SNMP SET failed to delete just-used ciscoPingEntry on proxy interface {} with instance ID {}", (Object)proxyIpAddr, (Object)pingEntry.getCiscoPingSerialNumber());
        }
        if (destroyValues[0].toInt() != 6) {
            LOG.warn("SNMP SET to delete just-used ciscoPingEntry indicated row not deleted on proxy interface {} with instance ID {}", (Object)proxyIpAddr, (Object)pingEntry.getCiscoPingSerialNumber());
        }
    }

    private InetAddress determineTargetAddress(MonitoredService svc, Map<String, Object> parameters) {
        String rawOverrideTarget;
        String overrideTarget = rawOverrideTarget = ParameterMap.getKeyedString(parameters, (String)PARM_TARGET_IP_ADDR, null);
        if (rawOverrideTarget != null) {
            overrideTarget = PropertiesUtils.substitute((String)rawOverrideTarget, (Properties[])new Properties[]{this.getServiceProperties(svc)});
            LOG.debug("Expanded value '{}' of parameter {} to '{}' for service {} on interface {}", new Object[]{rawOverrideTarget, PARM_TARGET_IP_ADDR, overrideTarget, svc.getSvcName(), svc.getAddress()});
        }
        if (overrideTarget == null) {
            return svc.getAddress();
        }
        LOG.debug("Using user-specified override target IP address {} instead of service address {} for service {}", new Object[]{overrideTarget, svc.getAddress(), svc.getSvcName()});
        try {
            InetAddress overrideAddr = InetAddressUtils.addr((String)overrideTarget);
            LOG.debug("Overriding service address ({}) with user-specified target address ({}) for service {}", new Object[]{svc.getAddress(), overrideAddr, svc.getSvcName()});
            return overrideAddr;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to look up {} override value {} for service {}. Using service interface {} instead", new Object[]{PARM_TARGET_IP_ADDR, overrideTarget, svc.getSvcName(), svc.getAddress()});
            return svc.getAddress();
        }
    }

    private InetAddress determineProxyAddress(Map<String, Object> parameters, MonitoredService svc) {
        String rawProxyIpAddr;
        LOG.debug("Determining the proxy address on which to set up the ciscoPingEntry for target interface {}", (Object)svc.getAddress());
        OnmsNode proxyNode = null;
        InetAddress proxyAddress = null;
        String proxyNodeId = ParameterMap.getKeyedString(parameters, (String)PARM_PROXY_NODE_ID, null);
        String proxyNodeFS = ParameterMap.getKeyedString(parameters, (String)PARM_PROXY_FOREIGN_SOURCE, null);
        String proxyNodeFI = ParameterMap.getKeyedString(parameters, (String)PARM_PROXY_FOREIGN_ID, null);
        String proxyIpAddr = rawProxyIpAddr = ParameterMap.getKeyedString(parameters, (String)PARM_PROXY_IP_ADDR, null);
        if (rawProxyIpAddr != null) {
            proxyIpAddr = PropertiesUtils.substitute((String)rawProxyIpAddr, (Properties[])new Properties[]{this.getServiceProperties(svc)});
            LOG.debug("Expanded value '{}' of parameter {} to '{}' for service {} on interface {}", new Object[]{rawProxyIpAddr, PARM_PROXY_IP_ADDR, proxyIpAddr, svc.getSvcName(), svc.getAddress()});
        }
        if (proxyNodeFS != null && !proxyNodeFS.equals(PARM_VRF_NAME_DEFAULT) && proxyNodeFI != null && !proxyNodeFI.equals(PARM_VRF_NAME_DEFAULT)) {
            LOG.debug("Trying to look up proxy node with foreign-source {}, foreign-id {} for target interface {}", new Object[]{proxyNodeFS, proxyNodeFI, svc.getAddress()});
            proxyNode = s_nodeDao.findByForeignId(proxyNodeFS, proxyNodeFI);
            LOG.debug("Found a node via foreign-source / foreign-id '{}'/'{}' to use as proxy", (Object)proxyNodeFS, (Object)proxyNodeFI);
            if (proxyNode != null && proxyNode.getPrimaryInterface() != null) {
                proxyAddress = proxyNode.getPrimaryInterface().getIpAddress();
            }
        }
        if (proxyAddress != null) {
            LOG.info("Using address {} from node '{}':'{}' as proxy for service '{}' on interface {}", new Object[]{proxyAddress, proxyNodeFS, proxyNodeFI, svc.getSvcName(), svc.getIpAddr()});
            return proxyAddress;
        }
        if (proxyNodeId != null && Integer.valueOf(proxyNodeId) != null) {
            LOG.debug("Trying to look up proxy node with database ID {} for target interface {}", (Object)proxyNodeId, (Object)svc.getAddress());
            proxyNode = (OnmsNode)s_nodeDao.get((Serializable)Integer.valueOf(proxyNodeId));
            if (proxyNode != null && proxyNode.getPrimaryInterface() != null) {
                proxyAddress = proxyNode.getPrimaryInterface().getIpAddress();
            }
        }
        if (proxyAddress != null) {
            LOG.info("Using address {} from node with DBID {} as proxy for service '{}' on interface {}", new Object[]{proxyAddress, proxyNodeId, svc.getSvcName(), svc.getIpAddr()});
            return proxyAddress;
        }
        LOG.info("Trying to use address {} as proxy-ping agent address for target interface {}", (Object)proxyIpAddr, (Object)svc.getAddress());
        try {
            if (!PARM_VRF_NAME_DEFAULT.equals(proxyIpAddr)) {
                proxyAddress = InetAddressUtils.addr((String)proxyIpAddr);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (proxyAddress != null) {
            LOG.info("Using address {} (user-specified) as proxy for service '{}' on interface {}", new Object[]{proxyAddress, svc.getSvcName(), svc.getIpAddr()});
            return proxyAddress;
        }
        LOG.error("Unable to determine proxy address for service '{}' on interface '{}'. The poll will be unable to proceed.", (Object)svc.getSvcName(), (Object)svc.getIpAddr());
        return null;
    }

    private int determineAddrType(InetAddress ipaddr) {
        if (ipaddr instanceof Inet6Address) {
            LOG.debug("The address {} is IPv6", (Object)ipaddr);
            return 20;
        }
        if (ipaddr instanceof Inet4Address) {
            LOG.debug("The address {} is IPv4", (Object)ipaddr);
            return 1;
        }
        LOG.error("The address {} is neither IPv4 nor IPv6. Don't know how to proceed, giving up.", (Object)ipaddr);
        throw new RuntimeException("Cannot work with address " + ipaddr + " because it is neither IPv4 nor IPv6.");
    }

    private Properties getServiceProperties(MonitoredService svc) {
        Properties properties = new Properties();
        properties.put("ipaddr", svc.getIpAddr());
        properties.put("nodeid", (Object)svc.getNodeId());
        properties.put("nodelabel", svc.getNodeLabel());
        properties.put("svcname", svc.getSvcName());
        return properties;
    }

    private static final class CiscoPingEntry {
        private int m_ciscoPingSerialNumber;
        private int m_ciscoPingProtocol;
        private InetAddress m_ciscoPingAddress;
        private int m_ciscoPingPacketCount;
        private int m_ciscoPingPacketSize;
        private int m_ciscoPingPacketTimeout;
        private int m_ciscoPingPacketDelay;
        private String m_ciscoPingEntryOwner;
        private String m_ciscoPingVrfName;
        private int m_ciscoPingEntryStatus;

        private CiscoPingEntry() {
        }

        public int getCiscoPingSerialNumber() {
            return this.m_ciscoPingSerialNumber;
        }

        public void setCiscoPingSerialNumber(int ciscoPingSerialNumber) {
            this.m_ciscoPingSerialNumber = ciscoPingSerialNumber;
        }

        public int getCiscoPingProtocol() {
            return this.m_ciscoPingProtocol;
        }

        public void setCiscoPingProtocol(int ciscoPingProtocol) {
            this.m_ciscoPingProtocol = ciscoPingProtocol;
        }

        public InetAddress getCiscoPingAddress() {
            return this.m_ciscoPingAddress;
        }

        public byte[] getCiscoPingAddressBytes() {
            return this.m_ciscoPingAddress.getAddress();
        }

        public void setCiscoPingAddress(InetAddress ciscoPingAddress) {
            this.m_ciscoPingAddress = ciscoPingAddress;
        }

        public int getCiscoPingPacketCount() {
            return this.m_ciscoPingPacketCount;
        }

        public void setCiscoPingPacketCount(int ciscoPingPacketCount) {
            this.m_ciscoPingPacketCount = ciscoPingPacketCount;
        }

        public int getCiscoPingPacketSize() {
            return this.m_ciscoPingPacketSize;
        }

        public void setCiscoPingPacketSize(int ciscoPingPacketSize) {
            this.m_ciscoPingPacketSize = ciscoPingPacketSize;
        }

        public int getCiscoPingPacketTimeout() {
            return this.m_ciscoPingPacketTimeout;
        }

        public void setCiscoPingPacketTimeout(int ciscoPingPacketTimeout) {
            this.m_ciscoPingPacketTimeout = ciscoPingPacketTimeout;
        }

        public int getCiscoPingPacketDelay() {
            return this.m_ciscoPingPacketDelay;
        }

        public void setCiscoPingPacketDelay(int ciscoPingPacketDelay) {
            this.m_ciscoPingPacketDelay = ciscoPingPacketDelay;
        }

        public String getCiscoPingEntryOwner() {
            return this.m_ciscoPingEntryOwner;
        }

        public void setCiscoPingEntryOwner(String ciscoPingEntryOwner) {
            this.m_ciscoPingEntryOwner = ciscoPingEntryOwner;
        }

        public String getCiscoPingVrfName() {
            return this.m_ciscoPingVrfName;
        }

        public void setCiscoPingVrfName(String ciscoPingVrfName) {
            this.m_ciscoPingVrfName = ciscoPingVrfName;
        }

        public int getCiscoPingEntryStatus() {
            return this.m_ciscoPingEntryStatus;
        }

        public void setCiscoPingEntryStatus(int ciscoPingEntryStatus) {
            this.m_ciscoPingEntryStatus = ciscoPingEntryStatus;
        }

        public int calculateMinInitialWait() {
            return this.m_ciscoPingPacketCount * (this.m_ciscoPingPacketTimeout + this.m_ciscoPingPacketDelay);
        }

        public SnmpObjId[] generateCreateOids() {
            SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.2." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.3." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.4." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.5." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.6." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.7." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.15." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.16." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.17." + this.m_ciscoPingSerialNumber))};
            return oids;
        }

        public SnmpValue[] generateCreateValues() {
            SnmpValueFactory vf = SnmpUtils.getValueFactory();
            SnmpValue[] values = new SnmpValue[]{vf.getInt32(this.m_ciscoPingProtocol), vf.getOctetString(this.m_ciscoPingAddress.getAddress()), vf.getInt32(this.m_ciscoPingPacketCount), vf.getInt32(this.m_ciscoPingPacketSize), vf.getInt32(this.m_ciscoPingPacketTimeout), vf.getInt32(this.m_ciscoPingPacketDelay), vf.getOctetString(this.m_ciscoPingEntryOwner.getBytes()), vf.getInt32(this.m_ciscoPingEntryStatus), vf.getOctetString(this.m_ciscoPingVrfName.getBytes())};
            return values;
        }

        public SnmpObjId[] generateRowStatusOids() {
            SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.16." + this.m_ciscoPingSerialNumber))};
            return oids;
        }

        public SnmpValue[] generateRowStatusValues() {
            SnmpValueFactory vf = SnmpUtils.getValueFactory();
            SnmpValue[] values = new SnmpValue[]{vf.getInt32(this.m_ciscoPingEntryStatus)};
            return values;
        }

        public SnmpObjId[] generateResultsOids() {
            SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.9." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.10." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.11." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.12." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.13." + this.m_ciscoPingSerialNumber)), SnmpObjId.get((String)(".1.3.6.1.4.1.9.9.16.1.1.1.14." + this.m_ciscoPingSerialNumber))};
            return oids;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CiscoPingEntry: [ciscoPingSerialNumber=");
            sb.append(this.m_ciscoPingSerialNumber).append(",");
            sb.append("ciscoPingProtocol=").append(this.m_ciscoPingProtocol).append(",");
            sb.append("ciscoPingAddress=").append(this.m_ciscoPingAddress).append(",");
            sb.append("ciscoPingPacketCount=").append(this.m_ciscoPingPacketCount).append(",");
            sb.append("ciscoPingPacketSize=").append(this.m_ciscoPingPacketSize).append(",");
            sb.append("ciscoPingPacketTimeout=").append(this.m_ciscoPingPacketTimeout).append(",");
            sb.append("ciscoPingPacketDelay=").append(this.m_ciscoPingPacketDelay).append(",");
            sb.append("ciscoPingEntryOwner=").append(this.m_ciscoPingEntryOwner).append(",");
            sb.append("ciscoPingVrfName=").append(this.m_ciscoPingVrfName);
            sb.append("]");
            return sb.toString();
        }
    }
}

