/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;

public class MonitorTester {
    private static final String CMD_SYNTAX = "poller-test [options]";

    public static void main(String[] args) {
        Package pkg;
        Options options = new Options();
        Option oI = new Option("i", "ipaddress", true, "IP Address to test [required]");
        oI.setRequired(true);
        options.addOption(oI);
        Option oS = new Option("s", "service", true, "Service name [required]");
        oS.setRequired(true);
        options.addOption(oS);
        options.addOption("P", "package", true, "Poller Package");
        options.addOption("p", "param", true, "Service parameter ~ key=value");
        options.addOption("c", "class", true, "Monitor Class");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp(80, CMD_SYNTAX, String.format("ERROR: %s%n", e.getMessage()), options, null);
            System.exit(1);
        }
        String packageName = cmd.getOptionValue('P');
        String monitorClass = cmd.getOptionValue('c');
        final String ipAddress = cmd.getOptionValue('i');
        final String serviceName = cmd.getOptionValue('s');
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (cmd.hasOption('p')) {
            for (String parm : cmd.getOptionValues('p')) {
                String[] data = parm.split("=");
                if (data.length != 2 || data[0] == null || data[1] == null) continue;
                parameters.put(data[0], data[1]);
            }
        }
        MonitoredService monSvc = new MonitoredService(){

            public String getSvcUrl() {
                return null;
            }

            public String getSvcName() {
                return serviceName;
            }

            public String getIpAddr() {
                return ipAddress;
            }

            public int getNodeId() {
                return 0;
            }

            public String getNodeLabel() {
                return this.getIpAddr();
            }

            public NetworkInterface<InetAddress> getNetInterface() {
                return new InetNetworkInterface(this.getAddress());
            }

            public InetAddress getAddress() {
                InetAddress addr = InetAddressUtils.addr((String)ipAddress);
                if (addr == null) {
                    throw new IllegalStateException("Error getting localhost address");
                }
                return addr;
            }
        };
        try {
            PollerConfigFactory.init();
        }
        catch (Exception e) {
            System.err.printf("Error: Can't initialize poller-configuration.xml. %s%n", e.getMessage());
            System.exit(1);
        }
        PollerConfig config = PollerConfigFactory.getInstance();
        System.out.printf("Checking service %s on IP %s%n", serviceName, ipAddress);
        Package package_ = pkg = packageName == null ? config.getFirstLocalPackageMatch(ipAddress) : config.getPackage(packageName);
        if (pkg == null) {
            System.err.printf("Error: Package %s doesn't exist%n", packageName);
            System.exit(1);
        }
        System.out.printf("Package: %s%n", pkg.getName());
        Service svc = config.getServiceInPackage(serviceName, pkg);
        if (svc == null) {
            System.err.printf("Error: Service %s not defined on package %s%n", serviceName, packageName);
            System.exit(1);
        }
        ServiceMonitor monitor = null;
        if (monitorClass == null) {
            monitor = config.getServiceMonitor(serviceName);
            if (monitor == null) {
                System.err.printf("Error: Service %s doesn't have a monitor class defined%n", serviceName);
                System.exit(1);
            }
        } else {
            try {
                Class<ServiceMonitor> mc = Class.forName(monitorClass).asSubclass(ServiceMonitor.class);
                monitor = mc.newInstance();
            }
            catch (Exception e) {
                System.err.printf("Error: Can't instantiate %s because %s%n", monitorClass, e.getMessage());
                System.exit(1);
            }
        }
        System.out.printf("Monitor: %s%n", monitor.getClass().getName());
        if (config.isPolledLocally(ipAddress, serviceName)) {
            for (Parameter parameter : svc.getParameters()) {
                if (parameters.containsKey(parameter.getKey())) continue;
                parameters.put(parameter.getKey(), parameter.getValue() == null ? parameter.getAnyObject() : parameter.getValue());
            }
            for (Map.Entry entry : parameters.entrySet()) {
                System.out.printf("Parameter %s : %s%n", entry.getKey(), entry.getValue());
            }
            try {
                PollStatus status = monitor.poll(monSvc, parameters);
                System.out.printf("Available ? %s (status %s[%s])%n", status.isAvailable(), status.getStatusName(), status.getStatusCode());
                if (status.isAvailable()) {
                    System.out.printf("Response time: %s%n", status.getResponseTime());
                } else if (status.getReason() != null) {
                    System.out.printf("Reason: %s%n", status.getReason());
                }
            }
            catch (Exception e) {
                System.err.println("Error: Can't execute the monitor. " + e.getMessage());
                System.exit(1);
            }
        } else {
            System.err.printf("Error: Polling is not enabled for service %s using IP %s%n", serviceName, ipAddress);
        }
        System.exit(0);
    }
}

