/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.List;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.MicroblogNotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogReplyNotificationStrategy
extends MicroblogNotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MicroblogReplyNotificationStrategy.class);

    public MicroblogReplyNotificationStrategy() throws IOException {
    }

    public MicroblogReplyNotificationStrategy(Resource configResource) {
        super(configResource);
    }

    @Override
    public int send(List<Argument> arguments) {
        Status response;
        Twitter svc = this.buildUblogService(arguments);
        String destUser = this.findDestName(arguments);
        if (destUser == null || "".equals(destUser)) {
            LOG.error("Cannot send a microblog reply notice to a user with no microblog username set. Either set a microblog username for this OpenNMS user or use the MicroblogUpdateNotificationStrategy instead.");
            return 1;
        }
        if (destUser.startsWith("@")) {
            destUser = destUser.substring(1);
        }
        String fullMessage = String.format("@%s %s", destUser, this.buildMessageBody(arguments));
        LOG.debug("Dispatching microblog reply notification at base URL '{}' with message '{}'", (Object)svc.getConfiguration().getClientURL(), (Object)fullMessage);
        try {
            response = svc.updateStatus(fullMessage);
        }
        catch (TwitterException e) {
            LOG.error("Microblog notification failed at service URL '{}'", (Object)svc.getConfiguration().getClientURL(), (Object)e);
            return 1;
        }
        LOG.info("Microblog reply notification succeeded: reply update posted with ID {}", (Object)response.getId());
        return 0;
    }
}

