/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.snmp.LldpHelper;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;

public class LldpLocPortGetter
extends TableTracker {
    public static final SnmpObjId LLDP_LOC_PORTID_SUBTYPE = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.2");
    public static final SnmpObjId LLDP_LOC_PORTID = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.3");
    public static final SnmpObjId LLDP_LOC_DESCR = SnmpObjId.get((String)".1.0.8802.1.1.2.1.3.7.1.4");
    private SnmpAgentConfig m_agentConfig;

    public LldpLocPortGetter(SnmpAgentConfig peer) {
        super(new SnmpObjId[0]);
        this.m_agentConfig = peer;
    }

    public LldpLink get(Integer lldpRemLocalPortNum) {
        SnmpObjId instance = SnmpObjId.get((String)lldpRemLocalPortNum.toString());
        SnmpObjId[] oids = new SnmpObjId[]{SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID_SUBTYPE, (SnmpObjId)instance), SnmpObjId.get((SnmpObjId)LLDP_LOC_PORTID, (SnmpObjId)instance), SnmpObjId.get((SnmpObjId)LLDP_LOC_DESCR, (SnmpObjId)instance)};
        SnmpValue[] val = SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId[])oids);
        if (val == null || val.length != 3 || val[0] == null || val[1] == null || !val[0].isNumeric()) {
            return null;
        }
        LldpLink lldplink = new LldpLink();
        lldplink.setLldpLocalPortNum(lldpRemLocalPortNum);
        lldplink.setLldpPortId(LldpHelper.decodeLldpLink(val[0].toInt(), val[1]));
        lldplink.setLldpPortIdSubType(LldpLink.LldpPortIdSubType.get((Integer)val[0].toInt()));
        if (val[2] != null) {
            lldplink.setLldpPortDescr(val[2].toDisplayString());
        } else {
            lldplink.setLldpPortDescr("");
        }
        if (val[0].toInt() == LldpLink.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL.getValue().intValue()) {
            try {
                lldplink.setLldpPortIfindex(Integer.valueOf(val[1].toInt()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return lldplink;
    }
}

