/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpTracker;
import org.opennms.netmgt.enlinkd.snmp.CiscoVtpVlanTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dBaseTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dStpPortTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1dTpFdbTableTracker;
import org.opennms.netmgt.enlinkd.snmp.Dot1qTpFdbTableTracker;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryBridge
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridge.class);
    public static final String CISCO_ENTERPRISE_OID = ".1.3.6.1.4.1.9";

    public NodeDiscoveryBridge(EnhancedLinkd linkd, LinkableSnmpNode node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        Map<Integer, String> vlanmap = this.getVtpVlanMap();
        if (vlanmap.isEmpty()) {
            this.walkBridge(null, null);
        } else {
            for (Map.Entry<Integer, String> entry : vlanmap.entrySet()) {
                String community = this.getPeer().getReadCommunity();
                LOG.debug("run: cisco vlan collection setting peer community: {} with VLAN {}", (Object)community, (Object)entry.getKey());
                this.getPeer().setReadCommunity(community + "@" + entry.getKey());
                this.walkBridge(entry.getKey(), entry.getValue());
                this.getPeer().setReadCommunity(community);
            }
        }
        this.m_linkd.getQueryManager().reconcileBridge(this.getNodeId(), now);
        LOG.debug("run: collecting: {}", (Object)this.getPeer());
    }

    private Map<Integer, String> getVtpVlanMap() {
        final HashMap<Integer, String> vlanmap = new HashMap<Integer, String>();
        String trackerName = "vtpVersion";
        CiscoVtpTracker vtpStatus = new CiscoVtpTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)vtpStatus);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return vlanmap;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return vlanmap;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return vlanmap;
        }
        if (vtpStatus.getVtpVersion() == null) {
            LOG.info("run: cisco vtp mib not supported, on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return vlanmap;
        }
        LOG.info("run: cisco vtp mib supported, on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
        LOG.info("run: walking cisco vtp, on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
        trackerName = "ciscoVtpVlan";
        CiscoVtpVlanTableTracker ciscoVtpVlanTableTracker = new CiscoVtpVlanTableTracker(){

            @Override
            public void processCiscoVtpVlanRow(CiscoVtpVlanTableTracker.CiscoVtpVlanRow row) {
                if (row.isTypeEthernet() && row.isStatusOperational()) {
                    vlanmap.put(row.getVlanIndex(), row.getVlanName());
                }
            }
        };
        walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)ciscoVtpVlanTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
        return vlanmap;
    }

    protected void walkBridge(Integer vlan, String vlanname) {
        String trackerName = "dot1dbase";
        Dot1dBaseTracker dot1dbase = new Dot1dBaseTracker();
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)dot1dbase);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        BridgeElement bridge = dot1dbase.getBridgeElement();
        bridge.setVlan(vlan);
        bridge.setVlanname(vlanname);
        if (bridge.getBaseBridgeAddress() == null) {
            LOG.info("bridge mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        if (InetAddressUtils.isValidBridgeAddress((String)bridge.getBaseBridgeAddress())) {
            LOG.info("bridge not supported, base address identifier {} is not valid on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        if (bridge.getBaseNumPorts() == 0) {
            LOG.info("bridge {} has 0 port active, on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        LOG.info("bridge {} has is if type {}, on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)dot1dbase.getBridgeType()));
        if (bridge.getBaseType() == BridgeElement.BridgeDot1dBaseType.DOT1DBASETYPE_SOURCEROUTE_ONLY) {
            LOG.info("{}: source route only type bridge, on: {}", (Object)dot1dbase.getBridgeAddress(), (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), bridge);
        if (!InetAddressUtils.isValidStpBridgeId((String)bridge.getStpDesignatedRoot())) {
            LOG.info("spanning tree not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
        } else if (bridge.getStpProtocolSpecification() != 3) {
            LOG.info("ieee8021d spanning tree not supported on bridge {}, on: {}", (Object)bridge.getStpDesignatedRoot(), (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
        } else if (bridge.getBaseBridgeAddress().equals(InetAddressUtils.getBridgeAddressFromStpBridgeId((String)bridge.getStpDesignatedRoot()))) {
            LOG.info("designated root of spanning tree is itself on bridge {}, on: {}", (Object)bridge.getStpDesignatedRoot(), (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
        } else {
            this.walkSpanningTree(bridge.getBaseBridgeAddress(), vlan);
        }
        this.walkDot1dTpFdp(vlan);
        this.walkDot1qTpFdp();
    }

    private void walkDot1dTpFdp(final Integer vlan) {
        String trackerName = "dot1dTbFdbPortTable";
        Dot1dTpFdbTableTracker stpPortTableTracker = new Dot1dTpFdbTableTracker(){

            @Override
            public void processDot1dTpFdbRow(Dot1dTpFdbTableTracker.Dot1dTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                link.setVlan(vlan);
                if (InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress()) && link.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    NodeDiscoveryBridge.this.m_linkd.getQueryManager().store(NodeDiscoveryBridge.this.getNodeId(), link);
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
                return;
            }
            if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
    }

    private void walkDot1qTpFdp() {
        String trackerName = "dot1qTbFdbPortTable";
        Dot1qTpFdbTableTracker dot1qTpFdbTableTracker = new Dot1qTpFdbTableTracker(){

            @Override
            public void processDot1qTpFdbRow(Dot1qTpFdbTableTracker.Dot1qTpFdbRow row) {
                BridgeMacLink link = row.getLink();
                if (InetAddressUtils.isValidBridgeAddress((String)link.getMacAddress()) && link.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    NodeDiscoveryBridge.this.m_linkd.getQueryManager().store(NodeDiscoveryBridge.this.getNodeId(), link);
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)dot1qTpFdbTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
    }

    private void walkSpanningTree(final String baseBridgeAddress, final Integer vlan) {
        String trackerName = "dot1dStpPortTable";
        Dot1dStpPortTableTracker stpPortTableTracker = new Dot1dStpPortTableTracker(){

            @Override
            public void processDot1dStpPortRow(Dot1dStpPortTableTracker.Dot1dStpPortRow row) {
                BridgeStpLink link = row.getLink();
                link.setVlan(vlan);
                if (!baseBridgeAddress.equals(link.getDesignatedBridgeAddress())) {
                    NodeDiscoveryBridge.this.m_linkd.getQueryManager().store(NodeDiscoveryBridge.this.getNodeId(), link);
                }
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)this.getPeer(), (String)trackerName, (CollectionTracker)stpPortTableTracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent timed out while scanning the {} table", (Object)trackerName);
            } else if (walker.failed()) {
                LOG.info("run:Aborting Bridge Linkd node scan : Agent failed while scanning the {} table: {}", (Object)trackerName, (Object)walker.getErrorMessage());
            }
        }
        catch (InterruptedException e) {
            LOG.error("run: Bridge Linkd node collection interrupted, exiting", (Throwable)e);
        }
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable BridgeLinkNodeDiscovery ip=" + InetAddressUtils.str((InetAddress)this.getTarget()) + " port=" + this.getPort() + " community=" + this.getReadCommunity() + " package=" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "BridgeLinkDiscovery";
    }
}

