/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeElementDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeStpLinkDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfElementDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.EnhancedLinkdService;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.BridgeStpLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.topology.BridgeTopology;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class EnhancedLinkdServiceImpl
implements EnhancedLinkdService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private NodeDao m_nodeDao;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;
    private OspfLinkDao m_ospfLinkDao;
    private OspfElementDao m_ospfElementDao;
    private IsIsLinkDao m_isisLinkDao;
    private IsIsElementDao m_isisElementDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private BridgeElementDao m_bridgeElementDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeStpLinkDao m_bridgeStpLinkDao;
    volatile Map<Integer, Map<Integer, Set<String>>> m_bftMap = new HashMap<Integer, Map<Integer, Set<String>>>();

    private void addBridgeForwardingTableEntry(Integer nodeid, Integer bridgeport, String mac) {
        Map<Object, Object> bft = new HashMap();
        if (this.m_bftMap.containsKey(nodeid)) {
            bft = this.m_bftMap.get(nodeid);
        }
        Set<String> macs = new HashSet<String>();
        if (bft.containsKey(bridgeport)) {
            macs = (Set)bft.get(bridgeport);
        }
        macs.add(mac);
        bft.put(bridgeport, macs);
        this.m_bftMap.put(nodeid, bft);
    }

    @Override
    public List<LinkableSnmpNode> getSnmpNodeList() {
        ArrayList<LinkableSnmpNode> nodes = new ArrayList<LinkableSnmpNode>();
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        for (OnmsNode node : this.m_nodeDao.findMatching(criteria)) {
            nodes.add(new LinkableSnmpNode(node.getId().intValue(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName()));
        }
        return nodes;
    }

    @Override
    public LinkableSnmpNode getSnmpNode(int nodeid) {
        Criteria criteria = new Criteria(OnmsNode.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("type", (Object)OnmsNode.NodeType.ACTIVE));
        criteria.addRestriction((Restriction)new EqRestriction("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY));
        criteria.addRestriction((Restriction)new EqRestriction("id", (Object)nodeid));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            return new LinkableSnmpNode(node.getId().intValue(), node.getPrimaryInterface().getIpAddress(), node.getSysObjectId(), node.getSysName());
        }
        return null;
    }

    @Override
    public void delete(int nodeId) {
        Date now = new Date();
        this.reconcileLldp(nodeId, now);
        this.reconcileCdp(nodeId, now);
        this.reconcileOspf(nodeId, now);
        this.reconcileIpNetToMedia(nodeId, now);
        this.reconcileBridge(nodeId, now);
    }

    @Override
    public void reconcileLldp(int nodeId, Date now) {
        LldpElement element = this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getLldpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_lldpElementDao.delete((Object)element);
            this.m_lldpElementDao.flush();
        }
        this.m_lldpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void reconcileOspf(int nodeId, Date now) {
        OspfElement element = this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getOspfNodeLastPollTime().getTime() < now.getTime()) {
            this.m_ospfElementDao.delete((Object)element);
            this.m_ospfElementDao.flush();
        }
        this.m_ospfLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ospfLinkDao.flush();
    }

    @Override
    public void reconcileIsis(int nodeId, Date now) {
        IsIsElement element = this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getIsisNodeLastPollTime().getTime() < now.getTime()) {
            this.m_isisElementDao.delete((Object)element);
            this.m_isisElementDao.flush();
        }
        this.m_isisLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_isisLinkDao.flush();
    }

    @Override
    public void reconcileCdp(int nodeId, Date now) {
        CdpElement element = this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId));
        if (element != null && element.getCdpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_cdpElementDao.delete((Object)element);
            this.m_cdpElementDao.flush();
        }
        this.m_cdpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_cdpLinkDao.flush();
    }

    @Override
    public void reconcileIpNetToMedia(int nodeId, Date now) {
        this.m_ipNetToMediaDao.deleteBySourceNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_ipNetToMediaDao.flush();
    }

    @Override
    public void store(int nodeId, CdpLink link) {
        if (link == null) {
            return;
        }
        this.saveCdpLink(nodeId, link);
    }

    @Transactional
    protected void saveCdpLink(final int nodeId, final CdpLink saveMe) {
        new UpsertTemplate<CdpLink, CdpLinkDao>(this.m_transactionManager, this.m_cdpLinkDao){

            protected CdpLink query() {
                return ((CdpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getCdpCacheIfIndex());
            }

            protected CdpLink doUpdate(CdpLink dbCdpLink) {
                dbCdpLink.merge(saveMe);
                ((CdpLinkDao)this.m_dao).update((Object)dbCdpLink);
                ((CdpLinkDao)this.m_dao).flush();
                return dbCdpLink;
            }

            protected CdpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setCdpLinkLastPollTime(saveMe.getCdpLinkCreateTime());
                ((CdpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((CdpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, LldpLink link) {
        if (link == null) {
            return;
        }
        this.saveLldpLink(nodeId, link);
    }

    @Transactional
    protected void saveLldpLink(final int nodeId, final LldpLink saveMe) {
        new UpsertTemplate<LldpLink, LldpLinkDao>(this.m_transactionManager, this.m_lldpLinkDao){

            protected LldpLink query() {
                return ((LldpLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getLldpLocalPortNum());
            }

            protected LldpLink doUpdate(LldpLink dbLldpLink) {
                dbLldpLink.merge(saveMe);
                ((LldpLinkDao)this.m_dao).update((Object)dbLldpLink);
                ((LldpLinkDao)this.m_dao).flush();
                return dbLldpLink;
            }

            protected LldpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setLldpLinkLastPollTime(saveMe.getLldpLinkCreateTime());
                ((LldpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((LldpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, CdpElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        CdpElement dbelement = node.getCdpElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setCdpElement(dbelement);
        } else {
            element.setNode(node);
            element.setCdpNodeLastPollTime(element.getCdpNodeCreateTime());
            node.setCdpElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, LldpElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        LldpElement dbelement = node.getLldpElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setLldpElement(dbelement);
        } else {
            element.setNode(node);
            element.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
            node.setLldpElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    public void store(int nodeId, OspfLink link) {
        if (link == null) {
            return;
        }
        this.saveOspfLink(nodeId, link);
    }

    private void saveOspfLink(final int nodeId, final OspfLink saveMe) {
        new UpsertTemplate<OspfLink, OspfLinkDao>(this.m_transactionManager, this.m_ospfLinkDao){

            protected OspfLink query() {
                return ((OspfLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getOspfRemRouterId(), saveMe.getOspfRemIpAddr(), saveMe.getOspfRemAddressLessIndex());
            }

            protected OspfLink doUpdate(OspfLink dbOspfLink) {
                dbOspfLink.merge(saveMe);
                ((OspfLinkDao)this.m_dao).update((Object)dbOspfLink);
                ((OspfLinkDao)this.m_dao).flush();
                return dbOspfLink;
            }

            protected OspfLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setOspfLinkLastPollTime(saveMe.getOspfLinkCreateTime());
                ((OspfLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((OspfLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, IsIsLink link) {
        if (link == null) {
            return;
        }
        this.saveIsisLink(nodeId, link);
    }

    @Transactional
    protected void saveIsisLink(final int nodeId, final IsIsLink saveMe) {
        new UpsertTemplate<IsIsLink, IsIsLinkDao>(this.m_transactionManager, this.m_isisLinkDao){

            protected IsIsLink query() {
                return ((IsIsLinkDao)this.m_dao).get(Integer.valueOf(nodeId), saveMe.getIsisCircIndex(), saveMe.getIsisISAdjIndex());
            }

            protected IsIsLink doUpdate(IsIsLink dbIsIsLink) {
                dbIsIsLink.merge(saveMe);
                ((IsIsLinkDao)this.m_dao).update((Object)dbIsIsLink);
                ((IsIsLinkDao)this.m_dao).flush();
                return dbIsIsLink;
            }

            protected IsIsLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setNode(node);
                saveMe.setIsisLinkLastPollTime(saveMe.getIsisLinkCreateTime());
                ((IsIsLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IsIsLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, OspfElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        OspfElement dbelement = node.getOspfElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setOspfElement(dbelement);
        } else {
            element.setNode(node);
            element.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
            node.setOspfElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, IsIsElement element) {
        if (element == null) {
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            return;
        }
        IsIsElement dbelement = node.getIsisElement();
        if (dbelement != null) {
            dbelement.merge(element);
            node.setIsisElement(dbelement);
        } else {
            element.setNode(node);
            element.setIsisNodeLastPollTime(element.getIsisNodeCreateTime());
            node.setIsisElement(element);
        }
        this.m_nodeDao.saveOrUpdate((Object)node);
        this.m_nodeDao.flush();
    }

    @Override
    public void store(int nodeId, BridgeElement bridge) {
        if (bridge == null) {
            return;
        }
        this.saveBridgeElement(nodeId, bridge);
    }

    @Transactional
    protected void saveBridgeElement(final int nodeId, final BridgeElement saveMe) {
        new UpsertTemplate<BridgeElement, BridgeElementDao>(this.m_transactionManager, this.m_bridgeElementDao){

            protected BridgeElement query() {
                return ((BridgeElementDao)this.m_dao).getByNodeIdVlan(Integer.valueOf(nodeId), saveMe.getVlan());
            }

            protected BridgeElement doUpdate(BridgeElement bridge) {
                bridge.merge(saveMe);
                ((BridgeElementDao)this.m_dao).update((Object)bridge);
                ((BridgeElementDao)this.m_dao).flush();
                return bridge;
            }

            protected BridgeElement doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setBridgeNodeLastPollTime(saveMe.getBridgeNodeCreateTime());
                ((BridgeElementDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeElementDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, BridgeStpLink link) {
        if (link == null) {
            return;
        }
        this.saveBridgeStpLink(nodeId, link);
    }

    @Transactional
    protected void saveBridgeStpLink(final int nodeId, final BridgeStpLink saveMe) {
        new UpsertTemplate<BridgeStpLink, BridgeStpLinkDao>(this.m_transactionManager, this.m_bridgeStpLinkDao){

            protected BridgeStpLink query() {
                return ((BridgeStpLinkDao)this.m_dao).getByNodeIdBridgePort(Integer.valueOf(nodeId), saveMe.getStpPort());
            }

            protected BridgeStpLink doUpdate(BridgeStpLink link) {
                link.merge(saveMe);
                ((BridgeStpLinkDao)this.m_dao).update((Object)link);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeStpLink doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setBridgeStpLinkLastPollTime(saveMe.getBridgeStpLinkCreateTime());
                ((BridgeStpLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeStpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, BridgeMacLink link) {
        if (link == null) {
            return;
        }
        this.addBridgeForwardingTableEntry(nodeId, link.getBridgePort(), link.getMacAddress());
    }

    @Override
    public synchronized void reconcileBridge(int nodeId, Date now) {
        HashMap nodesavedtopology;
        this.m_bridgeElementDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeElementDao.flush();
        this.m_bridgeStpLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeStpLinkDao.flush();
        Map<Integer, Set<String>> bft = this.m_bftMap.remove(nodeId);
        if (bft == null || bft.isEmpty()) {
            return;
        }
        HashSet<String> macs = new HashSet<String>();
        for (Set<String> portmacs : bft.values()) {
            macs.addAll(portmacs);
        }
        HashMap savedtopology = new HashMap();
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            if (maclink.getNode().getId() == nodeId || !macs.contains(maclink.getMacAddress())) continue;
            Map nodesavedtopology2 = new HashMap();
            if (savedtopology.containsKey(maclink.getNode().getId())) {
                nodesavedtopology2 = (Map)savedtopology.get(maclink.getNode().getId());
            }
            Set<String> macsonport = new HashSet<String>();
            if (nodesavedtopology2.containsKey(maclink.getBridgePort())) {
                macsonport = (Set)nodesavedtopology2.get(maclink.getBridgePort());
            }
            macsonport.add(maclink.getMacAddress());
            nodesavedtopology2.put(maclink.getBridgePort(), macsonport);
            savedtopology.put(maclink.getNode().getId(), nodesavedtopology2);
            break;
        }
        BridgeTopology topology = new BridgeTopology();
        for (Integer savednode : savedtopology.keySet()) {
            topology.addTopology(savednode, (Map)savedtopology.get(savednode), new HashSet());
        }
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(nodeId);
        for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodesavedtopology = new HashMap();
            nodesavedtopology.put(bblink.getDesignatedPort(), new HashSet());
            topology.addTopology(bblink.getDesignatedNode().getId(), nodesavedtopology, targets);
        }
        for (BridgeBridgeLink bblink : this.m_bridgeBridgeLinkDao.findByDesignatedNodeId(Integer.valueOf(nodeId))) {
            nodesavedtopology = new HashMap();
            nodesavedtopology.put(bblink.getBridgePort(), new HashSet());
            topology.addTopology(bblink.getNode().getId(), nodesavedtopology, targets);
        }
        topology.parseBFT(Integer.valueOf(nodeId), bft);
        for (BridgeTopology.BridgeTopologyLink btl : topology.getTopology()) {
            this.saveLink(btl);
        }
        for (Integer curNodeId : savedtopology.keySet()) {
            this.m_bridgeMacLinkDao.deleteByNodeIdOlderThen(curNodeId, now);
        }
        this.m_bridgeMacLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.deleteByNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeBridgeLinkDao.deleteByDesignatedNodeIdOlderThen(Integer.valueOf(nodeId), now);
        this.m_bridgeBridgeLinkDao.flush();
    }

    protected void saveLink(BridgeTopology.BridgeTopologyLink bridgelink) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)bridgelink.getBridgeTopologyPort().getNodeid());
        if (node == null) {
            return;
        }
        OnmsNode designatenode = null;
        if (bridgelink.getDesignateBridgePort() != null) {
            designatenode = (OnmsNode)this.m_nodeDao.get((Serializable)bridgelink.getDesignateBridgePort().getNodeid());
        }
        if (bridgelink.getMacs().isEmpty() && designatenode != null) {
            BridgeBridgeLink link = new BridgeBridgeLink();
            link.setNode(node);
            link.setBridgePort(bridgelink.getBridgeTopologyPort().getBridgePort());
            link.setDesignatedNode(designatenode);
            link.setDesignatedPort(bridgelink.getDesignateBridgePort().getBridgePort());
            this.saveBridgeBridgeLink(link);
            return;
        }
        for (String mac : bridgelink.getMacs()) {
            BridgeMacLink maclink1 = new BridgeMacLink();
            maclink1.setNode(node);
            maclink1.setBridgePort(bridgelink.getBridgeTopologyPort().getBridgePort());
            maclink1.setMacAddress(mac);
            this.saveBridgeMacLink(maclink1);
            if (designatenode == null) continue;
            BridgeMacLink maclink2 = new BridgeMacLink();
            maclink2.setNode(designatenode);
            maclink2.setBridgePort(bridgelink.getDesignateBridgePort().getBridgePort());
            maclink2.setMacAddress(mac);
            this.saveBridgeMacLink(maclink2);
        }
    }

    @Transactional
    protected void saveBridgeMacLink(final BridgeMacLink saveMe) {
        new UpsertTemplate<BridgeMacLink, BridgeMacLinkDao>(this.m_transactionManager, this.m_bridgeMacLinkDao){

            protected BridgeMacLink query() {
                return ((BridgeMacLinkDao)this.m_dao).getByNodeIdBridgePort(saveMe.getNode().getId(), saveMe.getBridgePort());
            }

            protected BridgeMacLink doUpdate(BridgeMacLink link) {
                link.merge(saveMe);
                ((BridgeMacLinkDao)this.m_dao).update((Object)link);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeMacLink doInsert() {
                saveMe.setBridgeMacLinkLastPollTime(saveMe.getBridgeMacLinkCreateTime());
                ((BridgeMacLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeMacLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Transactional
    protected void saveBridgeBridgeLink(final BridgeBridgeLink saveMe) {
        new UpsertTemplate<BridgeBridgeLink, BridgeBridgeLinkDao>(this.m_transactionManager, this.m_bridgeBridgeLinkDao){

            protected BridgeBridgeLink query() {
                return ((BridgeBridgeLinkDao)this.m_dao).getByNodeIdBridgePort(saveMe.getNode().getId(), saveMe.getBridgePort());
            }

            protected BridgeBridgeLink doUpdate(BridgeBridgeLink link) {
                link.merge(saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).update((Object)link);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return link;
            }

            protected BridgeBridgeLink doInsert() {
                saveMe.setBridgeBridgeLinkLastPollTime(saveMe.getBridgeBridgeLinkCreateTime());
                ((BridgeBridgeLinkDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((BridgeBridgeLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public void store(int nodeId, IpNetToMedia ipnettomedia) {
        if (ipnettomedia == null) {
            return;
        }
        this.saveIpNetToMedia(nodeId, ipnettomedia);
    }

    @Transactional
    protected void saveIpNetToMedia(final int nodeId, final IpNetToMedia saveMe) {
        new UpsertTemplate<IpNetToMedia, IpNetToMediaDao>(this.m_transactionManager, this.m_ipNetToMediaDao){

            protected IpNetToMedia query() {
                return ((IpNetToMediaDao)this.m_dao).getByNetAndPhysAddress(saveMe.getNetAddress(), saveMe.getPhysAddress());
            }

            protected IpNetToMedia doUpdate(IpNetToMedia dbIpNetToMedia) {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setSourceNode(node);
                dbIpNetToMedia.merge(saveMe);
                ((IpNetToMediaDao)this.m_dao).update((Object)dbIpNetToMedia);
                ((IpNetToMediaDao)this.m_dao).flush();
                return dbIpNetToMedia;
            }

            protected IpNetToMedia doInsert() {
                OnmsNode node = (OnmsNode)EnhancedLinkdServiceImpl.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                if (node == null) {
                    return null;
                }
                saveMe.setSourceNode(node);
                saveMe.setLastPollTime(saveMe.getCreateTime());
                ((IpNetToMediaDao)this.m_dao).saveOrUpdate((Object)saveMe);
                ((IpNetToMediaDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }

    public IsIsElementDao getIsisElementDao() {
        return this.m_isisElementDao;
    }

    public void setIsisElementDao(IsIsElementDao isisElementDao) {
        this.m_isisElementDao = isisElementDao;
    }

    public BridgeElementDao getBridgeElementDao() {
        return this.m_bridgeElementDao;
    }

    public void setBridgeElementDao(BridgeElementDao bridgeElementDao) {
        this.m_bridgeElementDao = bridgeElementDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public BridgeStpLinkDao getBridgeStpLinkDao() {
        return this.m_bridgeStpLinkDao;
    }

    public void setBridgeStpLinkDao(BridgeStpLinkDao bridgeStpLinkDao) {
        this.m_bridgeStpLinkDao = bridgeStpLinkDao;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }
}

