/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryPingResponseCallback
implements PingResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryPingResponseCallback.class);
    static final String EVENT_SOURCE_VALUE = "OpenNMS.Discovery";
    private DiscoveryConfigFactory m_discoveryFactory;

    public void handleResponse(InetAddress address, EchoPacket response) {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", EVENT_SOURCE_VALUE);
        eb.setInterface(address);
        eb.setHost(InetAddressUtils.getLocalHostName());
        eb.addParam("RTT", response.getReceivedTimeNanos() - response.getSentTimeNanos());
        String foreignSource = this.getDiscoveryFactory().getForeignSource(address);
        if (foreignSource != null) {
            eb.addParam("foreignSource", foreignSource);
        }
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(eb.getEvent());
            LOG.debug("Sent event: {}", (Object)"uei.opennms.org/internal/discovery/newSuspect");
        }
        catch (Throwable t) {
            LOG.warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    public void handleTimeout(InetAddress address, EchoPacket request) {
        LOG.debug("request timed out: {}", (Object)address);
    }

    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        LOG.debug("an error occurred pinging {}", (Object)address, (Object)t);
    }

    public DiscoveryConfigFactory getDiscoveryFactory() {
        return this.m_discoveryFactory;
    }

    public void setDiscoveryFactory(DiscoveryConfigFactory discoveryFactory) {
        this.m_discoveryFactory = discoveryFactory;
    }
}

