/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionFailed;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.model.events.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSpecification {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionSpecification.class);
    private Package m_package;
    private String m_svcName;
    private ServiceCollector m_collector;
    private Map<String, Object> m_parameters;

    public CollectionSpecification(Package wpkg, String svcName, ServiceCollector collector) {
        this.m_package = wpkg;
        this.m_svcName = svcName;
        this.m_collector = collector;
        this.initializeParameters();
    }

    public String getPackageName() {
        return this.m_package.getName();
    }

    private String storeByIfAlias() {
        return this.m_package.getStoreByIfAlias();
    }

    private String ifAliasComment() {
        return this.m_package.getIfAliasComment();
    }

    private String storeFlagOverride() {
        return this.m_package.getStorFlagOverride();
    }

    private String ifAliasDomain() {
        return this.m_package.getIfAliasDomain();
    }

    private String storeByNodeId() {
        return this.m_package.getStoreByNodeID();
    }

    private Service getService() {
        return this.m_package.getService(this.m_svcName);
    }

    public String getServiceName() {
        return this.m_svcName;
    }

    private void setPackage(Package pkg) {
        this.m_package = pkg;
    }

    public long getInterval() {
        return this.getService().getInterval();
    }

    public String toString() {
        return this.m_svcName + '/' + this.m_package.getName();
    }

    private ServiceCollector getCollector() {
        return this.m_collector;
    }

    private Map<String, Object> getPropertyMap() {
        return this.m_parameters;
    }

    public Map<String, Object> getReadOnlyPropertyMap() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    private boolean isTrue(String stg) {
        return stg.equalsIgnoreCase("yes") || stg.equalsIgnoreCase("on") || stg.equalsIgnoreCase("true");
    }

    private boolean isFalse(String stg) {
        return stg.equalsIgnoreCase("no") || stg.equalsIgnoreCase("off") || stg.equalsIgnoreCase("false");
    }

    private void initializeParameters() {
        StringBuffer sb;
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("SERVICE", this.m_svcName);
        List params = this.getService().getParameters();
        for (Parameter p : params) {
            if (LOG.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("initializeParameters: adding service: ");
                sb.append(this.getServiceName());
                sb.append(" parameter: ");
                sb.append(p.getKey());
                sb.append(" of value ");
                sb.append(p.getValue());
                LOG.debug(sb.toString());
            }
            m.put(p.getKey(), p.getValue());
        }
        if (this.storeByIfAlias() != null && this.isTrue(this.storeByIfAlias())) {
            m.put("storeByIfAlias", "true");
            if (this.storeByNodeId() != null) {
                if (this.isTrue(this.storeByNodeId())) {
                    m.put("storeByNodeID", "true");
                } else if (this.isFalse(this.storeByNodeId())) {
                    m.put("storeByNodeID", "false");
                } else {
                    m.put("storeByNodeID", "normal");
                }
            }
            if (this.ifAliasDomain() != null) {
                m.put("domain", this.ifAliasDomain());
            } else {
                m.put("domain", this.getPackageName());
            }
            if (this.storeFlagOverride() != null && this.isTrue(this.storeFlagOverride())) {
                m.put("storFlagOverride", "true");
            }
            m.put("ifAliasComment", this.ifAliasComment());
            if (LOG.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("ifAliasDomain = ");
                sb.append(this.ifAliasDomain());
                sb.append(", storeByIfAlias = ");
                sb.append(this.storeByIfAlias());
                sb.append(", storeByNodeID = ");
                sb.append(this.storeByNodeId());
                sb.append(", storFlagOverride = ");
                sb.append(this.storeFlagOverride());
                sb.append(", ifAliasComment = ");
                sb.append(this.ifAliasComment());
                LOG.debug(sb.toString());
            }
        }
        m.put("packageName", this.m_package.getName());
        this.m_parameters = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(CollectionAgent agent) throws CollectionInitializationException {
        Collectd.instrumentation().beginCollectorInitialize(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            this.m_collector.initialize(agent, this.getPropertyMap());
        }
        finally {
            Collectd.instrumentation().endCollectorInitialize(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollectionAgent agent) {
        Collectd.instrumentation().beginCollectorRelease(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            this.m_collector.release(agent);
        }
        finally {
            Collectd.instrumentation().endCollectorRelease(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        }
    }

    public CollectionSet collect(CollectionAgent agent) throws CollectionException {
        Collectd.instrumentation().beginCollectorCollect(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        try {
            CollectionSet set = this.getCollector().collect(agent, (EventProxy)EventIpcManagerFactory.getIpcManager(), this.getPropertyMap());
            if (set.getStatus() == 2) {
                Collectd.instrumentation().reportCollectionException(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName, new CollectionFailed(2));
            }
            CollectionSet collectionSet = set;
            return collectionSet;
        }
        catch (CollectionException e) {
            Collectd.instrumentation().reportCollectionException(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName, e);
            throw e;
        }
        finally {
            Collectd.instrumentation().endCollectorCollect(this.m_package.getName(), agent.getNodeId(), agent.getHostAddress(), this.m_svcName);
        }
    }

    public boolean scheduledOutage(CollectionAgent agent) {
        boolean outageFound = false;
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        for (String outageName : this.m_package.getOutageCalendars()) {
            if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage((long)agent.getNodeId(), outageName) && !outageFactory.isInterfaceInOutage(agent.getHostAddress(), outageName)) continue;
            LOG.debug("scheduledOutage: configured outage '{}' applies, interface {} will not be collected for {}", new Object[]{outageName, agent.getHostAddress(), this});
            outageFound = true;
            break;
        }
        return outageFound;
    }

    public void refresh(CollectdConfigFactory collectorConfigDao) {
        Package refreshedPackage = collectorConfigDao.getPackage(this.getPackageName());
        if (refreshedPackage != null) {
            this.setPackage(refreshedPackage);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_collector.getRrdRepository(collectionName);
    }
}

