/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TcpPlugin.class);
    private static final String PROTOCOL_NAME = "TCP";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout, Pattern regex, StringBuffer bannerResult) {
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                LOG.debug("TcpPlugin: connected to host: {} on port: {}", (Object)port, (Object)host);
                if (regex == null) {
                    isAServer = true;
                    continue;
                }
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String response = lineRdr.readLine();
                if (regex.matcher(response).find()) {
                    LOG.debug("isServer: matching response= {}", (Object)response);
                    isAServer = true;
                    if (bannerResult == null) continue;
                    bannerResult.append(response);
                    continue;
                }
                isAServer = false;
                LOG.debug("isServer: NON-matching response= {}", (Object)response);
                break;
            }
            catch (ConnectException e) {
                LOG.debug("TcpPlugin: Connection refused to {}: {}", (Object)port, (Object)InetAddressUtils.str((InetAddress)host));
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                LOG.info("TcpPlugin: Could not connect to host {}, no route to host", (Object)InetAddressUtils.str((InetAddress)host), (Object)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                LOG.debug("TcpPlugin: did not connect to host within timeout: {} attempt: {}", (Object)attempts, (Object)timeout);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                LOG.info("TcpPlugin: An expected I/O exception occured connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, e});
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                LOG.warn("TcpPlugin: An undeclared throwable exception was caught connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)host), port, t});
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int port = -1;
        String banner = null;
        String match = null;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)-1);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
        }
        if (port == -1) {
            throw new IllegalArgumentException("The port must be specified when doing TCP discovery");
        }
        try {
            StringBuffer bannerResult = null;
            Pattern regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = Pattern.compile(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = Pattern.compile(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, port, retries, timeout, regex, bannerResult);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (PatternSyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

