/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.SslSocketWrapper;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLCertPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SSLCertPlugin.class);
    private static final String PROTOCOL_NAME = "SSLCert";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_PORT = -1;
    public static final String PARAMETER_TIMEOUT = "timeout";
    public static final String PARAMETER_RETRY = "retry";
    public static final String PARAMETER_PORT = "port";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected SSL certificate checking not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)PARAMETER_RETRY, (int)0);
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)PARAMETER_TIMEOUT, (int)5000);
        int port = ParameterMap.getKeyedInteger(qualifiers, (String)PARAMETER_PORT, (int)-1);
        if (port == -1) {
            throw new IllegalArgumentException("The port must be specified when doing SSL certificate discovery");
        }
        boolean hasSSLCert = false;
        for (int attempts = 0; attempts <= retries && !hasSSLCert; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(address, port), timeout);
                socket.setSoTimeout(timeout);
                LOG.debug("Connected to host: {} on port: {}", (Object)address, (Object)port);
                SSLSocket sslSocket = (SSLSocket)this.getSocketWrapper().wrapSocket(socket);
                hasSSLCert = sslSocket.getSession().isValid();
                continue;
            }
            catch (ConnectException e) {
                LOG.debug("Connection refused to {}:{}", (Object)InetAddressUtils.str((InetAddress)address), (Object)port);
                hasSSLCert = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                LOG.info("Could not connect to host {}, no route to host", (Object)InetAddressUtils.str((InetAddress)address), (Object)e);
                hasSSLCert = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                LOG.debug("Did not connect to host within timeout: {}, attempt: {}", (Object)timeout, (Object)attempts);
                hasSSLCert = false;
                continue;
            }
            catch (IOException e) {
                LOG.info("An expected I/O exception occured connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)address), port, e});
                hasSSLCert = false;
                continue;
            }
            catch (Throwable t) {
                hasSSLCert = false;
                LOG.warn("An undeclared throwable exception was caught connecting to host {} on port {}", new Object[]{InetAddressUtils.str((InetAddress)address), port, t});
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return hasSSLCert;
    }

    protected SocketWrapper getSocketWrapper() {
        return new SslSocketWrapper();
    }
}

